/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.MortalCacheValue;
import org.infinispan.container.entries.TransientMortalCacheEntry;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=1241)
public class TransientMortalCacheValue
extends MortalCacheValue {
    protected long maxIdle;
    protected long lastUsed;

    public TransientMortalCacheValue(Object value, long created, long lifespan, long maxIdle, long lastUsed) {
        this(value, null, created, lifespan, maxIdle, lastUsed);
    }

    protected TransientMortalCacheValue(Object value, PrivateMetadata internalMetadata, long created, long lifespan, long maxIdle, long lastUsed) {
        super(value, internalMetadata, created, lifespan);
        this.maxIdle = maxIdle;
        this.lastUsed = lastUsed;
    }

    @ProtoFactory
    TransientMortalCacheValue(MarshallableObject<?> wrappedValue, PrivateMetadata internalMetadata, long created, long lifespan, long maxIdle, long lastUsed) {
        super(wrappedValue, internalMetadata, created, lifespan);
        this.maxIdle = maxIdle;
        this.lastUsed = lastUsed;
    }

    @Override
    @ProtoField(value=5)
    public long getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(long maxIdle) {
        this.maxIdle = maxIdle;
    }

    @Override
    @ProtoField(value=6)
    public long getLastUsed() {
        return this.lastUsed;
    }

    public void setLastUsed(long lastUsed) {
        this.lastUsed = lastUsed;
    }

    @Override
    public boolean isExpired(long now) {
        return ExpiryHelper.isExpiredTransientMortal(this.maxIdle, this.lastUsed, this.lifespan, this.created, now);
    }

    @Override
    public boolean isMaxIdleExpirable() {
        return true;
    }

    @Override
    public InternalCacheEntry<?, ?> toInternalCacheEntry(Object key) {
        return new TransientMortalCacheEntry(key, this.value, this.internalMetadata, this.maxIdle, this.lifespan, this.lastUsed, this.created);
    }

    @Override
    public long getExpiryTime() {
        long muet;
        long lset = this.lifespan > -1L ? this.created + this.lifespan : -1L;
        long l = muet = this.maxIdle > -1L ? this.lastUsed + this.maxIdle : -1L;
        if (lset == -1L) {
            return muet;
        }
        if (muet == -1L) {
            return lset;
        }
        return Math.min(lset, muet);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TransientMortalCacheValue)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TransientMortalCacheValue that = (TransientMortalCacheValue)o;
        return this.lastUsed == that.lastUsed && this.maxIdle == that.maxIdle;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.maxIdle ^ this.maxIdle >>> 32);
        result = 31 * result + (int)(this.lastUsed ^ this.lastUsed >>> 32);
        return result;
    }

    @Override
    public TransientMortalCacheValue clone() {
        return (TransientMortalCacheValue)super.clone();
    }

    @Override
    protected void appendFieldsToString(StringBuilder builder) {
        super.appendFieldsToString(builder);
        builder.append(", maxIdle=").append(this.maxIdle);
        builder.append(", lastUsed=").append(this.lastUsed);
    }
}

