/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.util.concurrent.CompletionStage;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.NodeVersion;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CommandAckCollector;

@ProtoTypeId(value=1023)
public class BackupMultiKeyAckCommand
extends BaseRpcCommand {
    @ProtoField(value=2)
    final long id;
    @ProtoField(value=3)
    final int topologyId;
    @ProtoField(value=4)
    final int segment;

    @ProtoFactory
    public BackupMultiKeyAckCommand(ByteString cacheName, long id, int segment, int topologyId) {
        super(cacheName);
        this.id = id;
        this.topologyId = topologyId;
        this.segment = segment;
    }

    public void ack(CommandAckCollector ackCollector) {
        ackCollector.backupAck(this.id, this.getOrigin(), this.segment, this.topologyId);
    }

    @Override
    public final boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public NodeVersion supportedSince() {
        return NodeVersion.SIXTEEN;
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry registry) throws Throwable {
        throw new UnsupportedOperationException("Should not happen");
    }

    @Override
    public String toString() {
        return "BackupMultiKeyAckCommand{id=" + this.id + ", segment=" + this.segment + ", topologyId=" + this.topologyId + "}";
    }
}

