/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cache.impl;

import java.util.Map;
import org.infinispan.cache.impl.EncodingFunction;
import org.infinispan.commands.functional.functions.InjectableComponent;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.metadata.Metadata;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=1072)
@Scope(value=Scopes.NAMED_CACHE)
public class EncoderEntryMapper<K, V, T extends Map.Entry<K, V>>
implements EncodingFunction<T>,
InjectableComponent {
    @Inject
    transient InternalEntryFactory entryFactory;
    @ProtoField(value=1)
    final DataConversion keyDataConversion;
    @ProtoField(value=2)
    final DataConversion valueDataConversion;

    public static <K, V> EncoderEntryMapper<K, V, Map.Entry<K, V>> newEntryMapper(DataConversion keyDataConversion, DataConversion valueDataConversion, InternalEntryFactory entryFactory) {
        EncoderEntryMapper mapper = new EncoderEntryMapper(keyDataConversion, valueDataConversion);
        mapper.entryFactory = entryFactory;
        return mapper;
    }

    public static <K, V> EncoderEntryMapper<K, V, CacheEntry<K, V>> newCacheEntryMapper(DataConversion keyDataConversion, DataConversion valueDataConversion, InternalEntryFactory entryFactory) {
        EncoderEntryMapper mapper = new EncoderEntryMapper(keyDataConversion, valueDataConversion);
        mapper.entryFactory = entryFactory;
        return mapper;
    }

    @ProtoFactory
    EncoderEntryMapper(DataConversion keyDataConversion, DataConversion valueDataConversion) {
        this.keyDataConversion = keyDataConversion;
        this.valueDataConversion = valueDataConversion;
    }

    @Inject
    public void injectDependencies(ComponentRegistry registry) {
        registry.wireDependencies(this.keyDataConversion);
        registry.wireDependencies(this.valueDataConversion);
    }

    @Override
    public void inject(ComponentRegistry registry) {
        this.injectDependencies(registry);
        this.entryFactory = registry.getInternalEntryFactory().running();
    }

    @Override
    public T apply(T e) {
        Object key = e.getKey();
        Object value = e.getValue();
        Object newKey = this.keyDataConversion.fromStorage(key);
        Object newValue = this.valueDataConversion.fromStorage(value);
        if (key != newKey || value != newValue) {
            if (e instanceof CacheEntry) {
                CacheEntry ce = (CacheEntry)e;
                return (T)this.entryFactory.create(newKey, newValue, ce.getMetadata().version(), ce.getCreated(), ce.getLifespan(), ce.getLastUsed(), ce.getMaxIdle());
            }
            return (T)this.entryFactory.create(newKey, newValue, (Metadata)null);
        }
        return e;
    }
}

