/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.JmxStatisticsExposer;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.stats.CacheContainerStats;
import org.infinispan.stats.Stats;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="CacheContainerStats", description="General cache container statistics for a single node.")
@Scope(value=Scopes.GLOBAL)
public class CacheContainerStatsImpl
implements CacheContainerStats,
JmxStatisticsExposer {
    private static final Log log = LogFactory.getLog(CacheContainerStatsImpl.class);
    private final EmbeddedCacheManager cm;
    private final AtomicLong resetNanoseconds = new AtomicLong(0L);
    private boolean statisticsEnabled = false;
    @Inject
    TimeService timeService;
    private volatile StatsHolder enabledStats;

    public CacheContainerStatsImpl(EmbeddedCacheManager cm) {
        this.cm = cm;
    }

    @Start
    void start() {
        this.setStatisticsEnabled(SecurityActions.getCacheManagerConfiguration(this.cm).statistics());
    }

    @Override
    public void setStatisticsEnabled(boolean enabled) {
        this.statisticsEnabled = enabled;
        if (enabled) {
            this.resetNanoseconds.set(this.timeService.time());
        }
    }

    @Override
    public boolean getStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @Override
    public void resetStatistics() {
        if (this.getStatisticsEnabled()) {
            this.getEnabledStats().forEach(Stats::reset);
            this.resetNanoseconds.set(this.timeService.time());
        }
    }

    @ManagedAttribute(description="Enables or disables the gathering of statistics by this component", displayName="Statistics enabled", dataType=DataType.TRAIT, writable=true)
    public boolean isStatisticsEnabled() {
        return this.getStatisticsEnabled();
    }

    @Override
    @ManagedAttribute(description="Required minimum number of nodes to hold current cache data", displayName="Required minimum number of nodes")
    public int getRequiredMinimumNumberOfNodes() {
        int result = -1;
        for (Stats stats : this.getEnabledStats()) {
            result = Math.max(result, stats.getRequiredMinimumNumberOfNodes());
        }
        return result;
    }

    @Override
    @ManagedAttribute(description="Amount in bytes of memory used in a given cache container for entries with eviction", displayName="Container memory used by eviction")
    public long getDataMemoryUsed() {
        return this.calculateDataMemoryUsed();
    }

    private long calculateDataMemoryUsed() {
        long totalMemoryUsed = 0L;
        for (Stats stats : this.getEnabledStats()) {
            long memoryUsed = stats.getDataMemoryUsed();
            if (memoryUsed <= 0L) continue;
            totalMemoryUsed += memoryUsed;
        }
        return totalMemoryUsed;
    }

    @Override
    @ManagedAttribute(description="Amount in bytes of off-heap memory used by this cache container", displayName="Off-Heap memory used")
    public long getOffHeapMemoryUsed() {
        return this.calculateOffHeapUsed();
    }

    private long calculateOffHeapUsed() {
        long totalOffHeapUsed = 0L;
        for (Stats stats : this.getEnabledStats()) {
            long offHeapUsed = stats.getOffHeapMemoryUsed();
            if (offHeapUsed <= 0L) continue;
            totalOffHeapUsed += offHeapUsed;
        }
        return totalOffHeapUsed;
    }

    @Override
    public void reset() {
        this.resetStatistics();
    }

    private AdvancedCache<?, ?> getCache(String cacheName) {
        try {
            return SecurityActions.getUnwrappedCache(this.cm.getCache(cacheName)).getAdvancedCache();
        }
        catch (CacheException t) {
            log.cannotObtainFailedCache(cacheName, t);
            return null;
        }
    }

    private List<Stats> getEnabledStats() {
        if (this.enabledStats != null && !this.enabledStats.isExpired()) {
            return this.enabledStats.stats;
        }
        ArrayList<Stats> stats = new ArrayList<Stats>();
        for (String cn : this.cm.getCacheNames()) {
            Configuration cfg;
            AdvancedCache<?, ?> cache;
            if (!this.cm.isRunning(cn) || (cache = this.getCache(cn)) == null || !(cfg = cache.getCacheConfiguration()).statistics().enabled()) continue;
            stats.add(cache.getStats());
        }
        this.enabledStats = new StatsHolder(stats);
        return stats;
    }

    @Override
    public Json toJson() {
        return Json.object().set("statistics_enabled", (Object)this.statisticsEnabled).set("off_heap_memory_used", (Object)this.getOffHeapMemoryUsed()).set("data_memory_used", (Object)this.getDataMemoryUsed()).set("required_minimum_number_of_nodes", (Object)this.getRequiredMinimumNumberOfNodes());
    }

    private final class StatsHolder {
        final long expiration;
        final List<Stats> stats;

        StatsHolder(List<Stats> stats) {
            this.expiration = CacheContainerStatsImpl.this.timeService.expectedEndTime(1L, TimeUnit.SECONDS);
            this.stats = stats;
        }

        boolean isExpired() {
            return CacheContainerStatsImpl.this.timeService.isTimeExpired(this.expiration);
        }
    }
}

