/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.util.concurrent.FileSystemLock;
import org.infinispan.persistence.sifs.EntryHeader;
import org.infinispan.persistence.spi.PersistenceException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@MessageLogger(projectCode="ISPN")
@ValidIdRange(min=29001, max=29500)
public interface Log
extends BasicLogger {
    public static Log getLog(Class<?> clazz) {
        return (Log)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), Log.class, (String)clazz.getName());
    }

    @Message(value="Max size of index node (%d) is limited to 32767 bytes.", id=29001)
    public CacheConfigurationException maxNodeSizeLimitedToShort(int var1);

    @Message(value="Min size of index node (%d) must be less or equal to max size (%d).", id=29002)
    public CacheConfigurationException minNodeSizeMustBeLessOrEqualToMax(int var1, int var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Cannot truncate index", id=29006)
    public void cannotTruncateIndex(@Cause IOException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Cannot close/delete data file %d.", id=29010)
    public void cannotCloseDeleteFile(int var1, @Cause IOException var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Cannot close data file.", id=29011)
    public void cannotCloseFile(@Cause IOException var1);

    @Message(value="Compaction threshold (%f) should be between 0 (exclusively) and 1 (inclusively).", id=29012)
    public CacheConfigurationException invalidCompactionThreshold(double var1);

    @Message(value="Cannot open index on %s", id=29013)
    public PersistenceException cannotOpenIndex(String var1, @Cause IOException var2);

    @Message(value="Interrupted while stopping the store", id=29014)
    public PersistenceException interruptedWhileStopping(@Cause InterruptedException var1);

    @Message(value="Cannot clear data directory.", id=29017)
    public PersistenceException cannotClearData(@Cause IOException var1);

    @Message(value="The serialized form of key %s is too long (%d); with maxNodeSize=%d bytes you can use only keys serialized to at most %d bytes.", id=29018)
    public PersistenceException keyIsTooLong(Object var1, int var2, int var3, int var4);

    @Message(value="Cannot load key %s from index.", id=29019)
    public PersistenceException cannotLoadKeyFromIndex(Object var1, @Cause Exception var2);

    @Message(value="Index looks corrupt.", id=29020)
    public PersistenceException indexLooksCorrupt(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="File id %s encountered an exception while compacting, file may be orphaned", id=29021)
    public void compactorEncounteredException(@Cause Throwable var1, int var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Compaction skipping a corrupted entry for key %s, at %s:%s|%s that doesn't have enough bytes for header %s", id=29022)
    public void compactedFileNotLongEnough(byte[] var1, int var2, long var3, long var5, EntryHeader var7);

    @LogMessage(level=Logger.Level.FATAL)
    @Message(value="Error encountered with index, SIFS may not operate properly.", id=29023)
    public void fatalIndexError(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Clear encountered an exception, size stats for future invocations may be incorrect", id=29024)
    public void clearError(@Cause Throwable var1);

    @Message(value="Failed acquiring lock '%s' for SIFS", id=29025)
    public PersistenceException failedAcquiringLockFile(@Cause Throwable var1, FileSystemLock var2);
}

