/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.irac;

import java.util.concurrent.CompletionStage;
import org.infinispan.commands.irac.BaseIracCommand;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.marshall.protostream.impl.WrappedMessages;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.NodeVersion;
import org.infinispan.util.ByteString;

@ProtoTypeId(value=1102)
public class IracRequestStateCommand
extends BaseIracCommand {
    private final IntSet segments;
    private Address origin;

    public IracRequestStateCommand(ByteString cacheName, IntSet segments) {
        super(cacheName);
        this.segments = segments;
    }

    @ProtoFactory
    IracRequestStateCommand(ByteString cacheName, WrappedMessage segments) {
        this(cacheName, (IntSet)WrappedMessages.unwrap(segments));
    }

    @ProtoField(value=2)
    WrappedMessage getSegments() {
        return WrappedMessages.orElseNull(this.segments);
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry registry) throws Throwable {
        registry.getIracManager().wired().requestState(this.getOrigin(), this.segments);
        return CompletableFutures.completedNull();
    }

    @Override
    public Address getOrigin() {
        return this.origin;
    }

    @Override
    public void setOrigin(Address origin) {
        this.origin = origin;
    }

    @Override
    public NodeVersion supportedSince() {
        return NodeVersion.SIXTEEN;
    }

    public String toString() {
        return "IracRequestStateCommand{cacheName=" + String.valueOf(this.cacheName) + ", origin=" + String.valueOf(this.origin) + ", segments=" + String.valueOf(this.segments) + "}";
    }
}

