/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.irac;

import java.util.Objects;
import org.infinispan.commands.RequestUUID;
import org.infinispan.commons.util.Util;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=1094)
public class IracManagerKeyInfo {
    final int segment;
    final Object key;
    final RequestUUID owner;

    public IracManagerKeyInfo(int segment, Object key, RequestUUID owner) {
        this.segment = segment;
        this.key = Objects.requireNonNull(key);
        this.owner = Objects.requireNonNull(owner);
    }

    @ProtoFactory
    IracManagerKeyInfo(int segment, MarshallableObject<Object> wrappedKey, RequestUUID owner) {
        this(segment, MarshallableObject.unwrap(wrappedKey), owner);
    }

    public Object getKey() {
        return this.key;
    }

    @ProtoField(value=1)
    public int getSegment() {
        return this.segment;
    }

    @ProtoField(value=2)
    MarshallableObject<Object> getWrappedKey() {
        return MarshallableObject.create(this.key);
    }

    @ProtoField(value=3)
    public RequestUUID getOwner() {
        return this.owner;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IracManagerKeyInfo)) {
            return false;
        }
        IracManagerKeyInfo that = (IracManagerKeyInfo)o;
        return this.segment == that.getSegment() && this.key.equals(that.getKey()) && this.owner.equals(that.getOwner());
    }

    public int hashCode() {
        int result = this.segment;
        result = 31 * result + this.key.hashCode();
        result = 31 * result + this.owner.hashCode();
        return result;
    }

    public String toString() {
        return "IracManagerKeyInfoImpl{segment=" + this.segment + ", key=" + Util.toStr((Object)this.key) + ", owner=" + String.valueOf(this.owner) + "}";
    }
}

