/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport;

import org.infinispan.commons.util.Experimental;
import org.infinispan.remoting.RpcException;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.ValidResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;

@Experimental
public abstract class ValidResponseCollector<T>
implements ResponseCollector<Address, T> {
    @Override
    public final T addResponse(Address sender, Response response) {
        if (response instanceof ValidResponse) {
            return this.addValidResponse(sender, (ValidResponse)response);
        }
        if (response instanceof ExceptionResponse) {
            return this.addException(sender, ((ExceptionResponse)response).getException());
        }
        if (response instanceof CacheNotFoundResponse) {
            return this.addTargetNotFound(sender);
        }
        this.addException(sender, (Exception)((Object)new RpcException("Unknown response type: " + String.valueOf(response))));
        return null;
    }

    @Override
    public abstract T finish();

    protected abstract T addValidResponse(Address var1, ValidResponse<?> var2);

    protected abstract T addTargetNotFound(Address var1);

    protected abstract T addException(Address var1, Exception var2);
}

