/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.irac;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.infinispan.commands.irac.BaseIracCommand;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.Util;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.marshall.protostream.impl.MarshallableList;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.NodeVersion;
import org.infinispan.util.ByteString;
import org.infinispan.xsite.irac.IracManager;

@ProtoTypeId(value=1109)
public class IracTombstoneRemoteSiteCheckCommand
extends BaseIracCommand {
    final List<Object> keys;

    public IracTombstoneRemoteSiteCheckCommand(ByteString cacheName, List<Object> keys) {
        super(cacheName);
        this.keys = keys;
    }

    @ProtoFactory
    IracTombstoneRemoteSiteCheckCommand(ByteString cacheName, MarshallableList<Object> wrappedKeys) {
        super(cacheName);
        this.keys = MarshallableList.unwrap(wrappedKeys);
    }

    @ProtoField(value=2)
    MarshallableList<Object> getWrappedKeys() {
        return MarshallableList.create(this.keys);
    }

    public CompletionStage<IntSet> invokeAsync(ComponentRegistry registry) {
        int numberOfKeys = this.keys.size();
        IntSet toKeepIndexes = IntSets.mutableEmptySet((int)numberOfKeys);
        LocalizedCacheTopology topology = registry.getDistributionManager().getCacheTopology();
        IracManager iracManager = registry.getIracManager().running();
        for (int index = 0; index < numberOfKeys; ++index) {
            Object key = this.keys.get(index);
            if (topology.getDistribution(key).isPrimary() && !iracManager.containsKey(key)) continue;
            toKeepIndexes.set(index);
        }
        return CompletableFuture.completedFuture(toKeepIndexes);
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public NodeVersion supportedSince() {
        return NodeVersion.SIXTEEN;
    }

    public String toString() {
        return "IracSiteTombstoneCheckCommand{cacheName=" + String.valueOf(this.cacheName) + ", keys=" + this.keys.stream().map(Util::toStr).collect(Collectors.joining(",")) + "}";
    }
}

