/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.protostream.impl;

import java.io.IOException;
import java.util.Collection;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.marshall.protostream.impl.GlobalContextInitializer;
import org.infinispan.marshall.protostream.impl.GlobalMarshaller;
import org.infinispan.protostream.BaseMarshallerDelegate;
import org.infinispan.protostream.GeneratedMarshallerBase;
import org.infinispan.protostream.ProtobufTagMarshaller;
import org.infinispan.protostream.TagReader;
import org.infinispan.protostream.TagWriter;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

abstract class AbstractMarshallableCollection<T> {
    static final Log log = LogFactory.getLog(AbstractMarshallableCollection.class);

    AbstractMarshallableCollection() {
    }

    @ProtoField(value=1)
    int getSize() {
        throw log.marshallerNotOverridden(this.getClass().getName());
    }

    abstract Collection<T> get();

    static abstract class Marshaller
    extends GeneratedMarshallerBase
    implements ProtobufTagMarshaller<AbstractMarshallableCollection> {
        private final String typeName;
        private final GlobalMarshaller marshaller;
        private volatile BaseMarshallerDelegate<WrappedMessage> delegate;

        protected Marshaller(GlobalMarshaller marshaller) {
            this.marshaller = marshaller;
            this.typeName = GlobalContextInitializer.getFqTypeName(this.getJavaClass());
        }

        abstract Collection<Object> newCollection(int var1);

        abstract AbstractMarshallableCollection<?> newWrapperInstance(Collection<?> var1);

        public AbstractMarshallableCollection read(ProtobufTagMarshaller.ReadContext ctx) throws IOException {
            TagReader in = ctx.getReader();
            int tag = in.readTag();
            if (tag == 0) {
                return this.newWrapperInstance(this.newCollection(0));
            }
            if (tag != 8) {
                throw new IllegalStateException("Unexpected tag: " + tag);
            }
            int size = in.readInt32();
            Collection<Object> entries = this.newCollection(size);
            boolean done = false;
            block5: while (!done) {
                tag = in.readTag();
                switch (tag) {
                    case 0: {
                        done = true;
                        continue block5;
                    }
                    case 18: {
                        java.nio.ByteBuffer buf = in.readByteBuffer();
                        entries.add(this.marshaller.objectFromByteBuffer(buf));
                        continue block5;
                    }
                    case 26: {
                        if (this.delegate == null) {
                            this.delegate = ctx.getSerializationContext().getMarshallerDelegate(WrappedMessage.class);
                        }
                        int length = in.readUInt32();
                        int oldLimit = in.pushLimit(length);
                        WrappedMessage message = (WrappedMessage)this.readMessage(this.delegate, ctx);
                        entries.add(message.getValue());
                        in.checkLastTagWas(0);
                        in.popLimit(oldLimit);
                        continue block5;
                    }
                }
                if (in.skipField(tag)) continue;
                done = true;
            }
            return this.newWrapperInstance(entries);
        }

        public void write(ProtobufTagMarshaller.WriteContext ctx, AbstractMarshallableCollection abstractMarshallableCollection) throws IOException {
            Collection collection = abstractMarshallableCollection.get();
            if (collection != null && !collection.isEmpty()) {
                TagWriter writer = ctx.getWriter();
                writer.writeInt32(1, collection.size());
                for (Object entry : collection) {
                    if (entry == null || !this.marshaller.isMarshallableWithoutWrapping(entry)) {
                        ByteBuffer buf = this.marshaller.objectToBuffer(entry);
                        writer.writeBytes(2, buf.getBuf(), buf.getOffset(), buf.getLength());
                        continue;
                    }
                    if (this.delegate == null) {
                        this.delegate = ctx.getSerializationContext().getMarshallerDelegate(WrappedMessage.class);
                    }
                    this.writeNestedMessage(this.delegate, ctx, 3, new WrappedMessage(entry));
                }
            }
        }

        public String getTypeName() {
            return this.typeName;
        }
    }
}

