/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.util.function.BiFunction;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.functional.AbstractWriteKeyCommand;
import org.infinispan.commands.functional.Mutation;
import org.infinispan.commands.functional.Mutations;
import org.infinispan.commands.functional.functions.InjectableComponent;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.util.Util;
import org.infinispan.context.InvocationContext;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.impl.Params;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.NodeVersion;
import org.infinispan.util.ByteString;

@ProtoTypeId(value=1152)
public final class ReadWriteKeyValueCommand<K, V, T, R>
extends AbstractWriteKeyCommand<K, V> {
    private Object argument;
    private BiFunction<T, EntryView.ReadWriteEntryView<K, V>, R> f;
    private Object prevValue;
    private Metadata prevMetadata;

    public ReadWriteKeyValueCommand(ByteString cacheName, Object key, Object argument, BiFunction<T, EntryView.ReadWriteEntryView<K, V>, R> f, int segment, CommandInvocationId id, ValueMatcher valueMatcher, Params params, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        super(cacheName, key, valueMatcher, segment, id, params, keyDataConversion, valueDataConversion);
        this.argument = argument;
        this.f = f;
    }

    @ProtoFactory
    ReadWriteKeyValueCommand(ByteString cacheName, MarshallableObject<?> wrappedKey, long flagsWithoutRemote, int topologyId, int segment, CommandInvocationId commandInvocationId, Params params, ValueMatcher valueMatcher, DataConversion keyDataConversion, DataConversion valueDataConversion, MarshallableObject<?> wrappedArgument, MarshallableObject<BiFunction<T, EntryView.ReadWriteEntryView<K, V>, R>> wrappedFunction, MarshallableObject<?> wrappedPrevValue, MarshallableObject<Metadata> wrappedPrevMetadata, PrivateMetadata internalMetadata) {
        super(cacheName, wrappedKey, flagsWithoutRemote, topologyId, segment, commandInvocationId, params, valueMatcher, keyDataConversion, valueDataConversion, internalMetadata);
        this.argument = MarshallableObject.unwrap(wrappedArgument);
        this.f = MarshallableObject.unwrap(wrappedFunction);
        this.prevValue = MarshallableObject.unwrap(wrappedPrevValue);
        this.prevMetadata = MarshallableObject.unwrap(wrappedPrevMetadata);
    }

    @ProtoField(number=12, name="argument")
    MarshallableObject<?> getWrappedArgument() {
        return MarshallableObject.create(this.argument);
    }

    @ProtoField(number=13, name="function")
    MarshallableObject<BiFunction<T, EntryView.ReadWriteEntryView<K, V>, R>> getWrappedFunction() {
        return MarshallableObject.create(this.f);
    }

    @ProtoField(value=14)
    MarshallableObject<?> getWrappedPrevValue() {
        return MarshallableObject.create(this.prevValue);
    }

    @ProtoField(value=15)
    MarshallableObject<Metadata> getWrappedPrevMetadata() {
        return MarshallableObject.create(this.prevMetadata);
    }

    @Override
    public void init(ComponentRegistry componentRegistry) {
        super.init(componentRegistry);
        if (this.f instanceof InjectableComponent) {
            ((InjectableComponent)((Object)this.f)).inject(componentRegistry);
        }
    }

    @Override
    public boolean isConditional() {
        return true;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitReadWriteKeyValueCommand(ctx, this);
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.OWNER;
    }

    @Override
    public NodeVersion supportedSince() {
        return NodeVersion.SIXTEEN;
    }

    @Override
    public String toString() {
        return "ReadWriteKeyValueCommand{key=" + Util.toStr((Object)this.key) + ", argument=" + Util.toStr((Object)this.argument) + ", f=" + this.getBiFunction().getClass().getName() + ", prevValue=" + Util.toStr((Object)this.prevValue) + ", prevMetadata=" + Util.toStr((Object)this.prevMetadata) + ", flags=" + this.printFlags() + ", commandInvocationId=" + String.valueOf(this.commandInvocationId) + ", topologyId=" + this.getTopologyId() + ", valueMatcher=" + String.valueOf((Object)this.valueMatcher) + ", successful=" + this.successful + ", keyDataConversion=" + String.valueOf(this.keyDataConversion) + ", valueDataConversion=" + String.valueOf(this.valueDataConversion) + "}";
    }

    @Override
    public Mutation<K, V, R> toMutation(Object key) {
        return new Mutations.ReadWriteWithValue<K, V, T, R>(this.keyDataConversion, this.valueDataConversion, this.argument, this.f);
    }

    public void setPrevValueAndMetadata(Object prevValue, Metadata prevMetadata) {
        this.prevMetadata = prevMetadata;
        this.prevValue = prevValue;
    }

    public Object getArgument() {
        return this.argument;
    }

    public BiFunction<T, EntryView.ReadWriteEntryView<K, V>, R> getBiFunction() {
        return this.f;
    }

    public Object getPrevValue() {
        return this.prevValue;
    }

    public Metadata getPrevMetadata() {
        return this.prevMetadata;
    }
}

