/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.commands;

import java.util.concurrent.CompletionStage;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.NodeVersion;
import org.infinispan.util.ByteString;
import org.infinispan.xsite.statetransfer.XSiteStateConsumer;
import org.infinispan.xsite.statetransfer.XSiteStateTransferManager;

@ProtoTypeId(value=1273)
public class XSiteStateTransferStartReceiveCommand
extends BaseRpcCommand {
    @ProtoField(value=2)
    final String siteName;

    @ProtoFactory
    public XSiteStateTransferStartReceiveCommand(ByteString cacheName, String siteName) {
        super(cacheName);
        this.siteName = siteName;
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry registry) {
        XSiteStateTransferManager stateTransferManager = registry.getXSiteStateTransferManager().running();
        XSiteStateConsumer consumer = stateTransferManager.getStateConsumer();
        consumer.startStateTransfer(this.siteName);
        return CompletableFutures.completedNull();
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public NodeVersion supportedSince() {
        return NodeVersion.SIXTEEN;
    }

    @Override
    public String toString() {
        return "XSiteStateTransferStartReceiveCommand{siteName='" + this.siteName + "', cacheName=" + String.valueOf(this.cacheName) + "}";
    }
}

