/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.commands;

import java.util.concurrent.CompletionStage;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.NodeVersion;
import org.infinispan.util.ByteString;

@ProtoTypeId(value=1269)
public class XSiteStateTransferFinishReceiveCommand
extends BaseRpcCommand {
    @ProtoField(value=2)
    final String siteName;

    @ProtoFactory
    public XSiteStateTransferFinishReceiveCommand(ByteString cacheName, String siteName) {
        super(cacheName);
        this.siteName = siteName;
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry registry) {
        registry.getXSiteStateTransferManager().running().getStateConsumer().endStateTransfer(this.siteName);
        return CompletableFutures.completedNull();
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public NodeVersion supportedSince() {
        return NodeVersion.SIXTEEN;
    }

    @Override
    public String toString() {
        return "XSiteStateTransferFinishReceiveCommand{siteName='" + this.siteName + "', cacheName=" + String.valueOf(this.cacheName) + "}";
    }
}

