/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import io.reactivex.rxjava3.internal.operators.flowable.BlockingFlowableIterable;
import org.infinispan.affinity.impl.KeyAffinityServiceImpl;
import org.infinispan.cache.impl.CacheImpl;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.internal.CommonsBlockHoundIntegration;
import org.infinispan.container.offheap.OffHeapConcurrentMap;
import org.infinispan.container.offheap.SegmentedBoundedOffHeapDataContainer;
import org.infinispan.executors.LimitedExecutor;
import org.infinispan.expiration.impl.ClusterExpirationManager;
import org.infinispan.factories.impl.BasicComponentRegistryImpl;
import org.infinispan.factories.threads.EnhancedQueueExecutorFactory;
import org.infinispan.interceptors.impl.CacheMgmtInterceptor;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.marshall.protostream.impl.SerializationContextRegistryImpl;
import org.infinispan.persistence.manager.PersistenceManagerImpl;
import org.infinispan.persistence.sifs.TemporaryTable;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.statetransfer.StateConsumerImpl;
import org.infinispan.statetransfer.StateTransferLockImpl;
import org.infinispan.topology.ClusterCacheStatus;
import org.infinispan.topology.ClusterTopologyManagerImpl;
import org.infinispan.topology.LocalTopologyManagerImpl;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.recovery.RecoveryManagerImpl;
import org.jgroups.JChannel;
import org.jgroups.blocks.cs.TcpConnection;
import org.jgroups.fork.ForkChannel;
import org.jgroups.protocols.UNICAST3;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.util.TimeScheduler3;
import reactor.blockhound.BlockHound;
import reactor.blockhound.integration.BlockHoundIntegration;

public class CoreBlockHoundIntegration
implements BlockHoundIntegration {
    public void applyTo(BlockHound.Builder builder) {
        CoreBlockHoundIntegration.registerBlockingMethods(builder);
        CommonsBlockHoundIntegration.allowPublicMethodsToBlock((BlockHound.Builder)builder, OffHeapConcurrentMap.class);
        builder.allowBlockingCallsInside(SegmentedBoundedOffHeapDataContainer.class.getName(), "ensureSize");
        CommonsBlockHoundIntegration.allowPublicMethodsToBlock((BlockHound.Builder)builder, StateTransferLockImpl.class);
        CommonsBlockHoundIntegration.allowMethodsToBlock((BlockHound.Builder)builder, StateConsumerImpl.class, (boolean)false);
        builder.allowBlockingCallsInside(LimitedExecutor.class.getName(), "acquireLock");
        builder.disallowBlockingCallsInside(LimitedExecutor.class.getName(), "actualRun");
        builder.allowBlockingCallsInside(ClusterExpirationManager.class.getName(), "addStageToPermits");
        builder.allowBlockingCallsInside(KeyAffinityServiceImpl.class.getName(), "handleViewChange");
        builder.allowBlockingCallsInside(TransactionTable.class.getName(), "calculateMinTopologyId");
        builder.allowBlockingCallsInside(ClusterTopologyManagerImpl.class.getName(), "acquireUpdateLock");
        builder.allowBlockingCallsInside(ClusterCacheStatus.class.getName(), "acquireLock");
        builder.allowBlockingCallsInside(ClusterCacheStatus.class.getName() + "$ConflictResolution", "acquireLock");
        builder.allowBlockingCallsInside("org.infinispan.topology.RebalanceConfirmationCollector", "acquireLock");
        builder.allowBlockingCallsInside(PersistenceManagerImpl.class.getName(), "acquireReadLock");
        builder.allowBlockingCallsInside(JGroupsTransport.class.getName(), "withView");
        builder.disallowBlockingCallsInside(LimitedExecutor.class.getName(), "actualRun");
        builder.allowBlockingCallsInside(DefaultCacheManager.class.getName(), "stop");
        builder.allowBlockingCallsInside("io.reactivex.rxjava3.internal.operators.flowable.BlockingFlowableIterable$BlockingFlowableIterator", "signalConsumer");
        builder.allowBlockingCallsInside(EnhancedQueueExecutorFactory.class.getName(), "createExecutor");
        builder.allowBlockingCallsInside("org.infinispan.persistence.sifs.Index", "checkForExistingIndexSizeFile");
        builder.allowBlockingCallsInside(BlockingFlowableIterable.class.getName() + "$FlowableSubscriber", "signalConsumer");
        CoreBlockHoundIntegration.methodsToBeRemoved(builder);
        CoreBlockHoundIntegration.questionableMethodsAllowedToBlock(builder);
        this.jgroups(builder);
    }

    private void jgroups(BlockHound.Builder builder) {
        builder.allowBlockingCallsInside(JChannel.class.getName(), "send");
        builder.allowBlockingCallsInside(ForkChannel.class.getName(), "send");
        builder.allowBlockingCallsInside(TcpConnection.class.getName(), "connect");
        builder.allowBlockingCallsInside(TcpConnection.class.getName(), "send");
        builder.allowBlockingCallsInside(TcpConnection.class.getName() + "$Receiver", "run");
        builder.allowBlockingCallsInside(TimeScheduler3.class.getName(), "add");
        builder.allowBlockingCallsInside(GMS.class.getName(), "process");
        builder.allowBlockingCallsInside(UNICAST3.class.getName(), "triggerXmit");
    }

    private static void methodsToBeRemoved(BlockHound.Builder builder) {
        builder.allowBlockingCallsInside(RecoveryManagerImpl.class.getName(), "registerInDoubtTransaction");
        builder.allowBlockingCallsInside(TemporaryTable.class.getName(), "set");
    }

    private static void registerBlockingMethods(BlockHound.Builder builder) {
        builder.markAsBlocking(CacheImpl.class, "size", "()I");
        builder.markAsBlocking(CacheImpl.class, "size", "(J)I");
        builder.markAsBlocking(CacheImpl.class, "containsKey", "(Ljava/lang/Object;)Z");
        builder.markAsBlocking(CacheImpl.class, "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
        builder.markAsBlocking(CacheImpl.class, "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        builder.markAsBlocking("org.infinispan.interceptors.distribution.DistributionBulkInterceptor$BackingEntrySet", "stream", "()Lorg/infinispan/CacheStream;");
        builder.markAsBlocking("org.infinispan.interceptors.distribution.DistributionBulkInterceptor$BackingEntrySet", "parallelStream", "()Lorg/infinispan/CacheStream;");
    }

    private static void questionableMethodsAllowedToBlock(BlockHound.Builder builder) {
        CommonsBlockHoundIntegration.allowPublicMethodsToBlock((BlockHound.Builder)builder, BasicComponentRegistryImpl.class);
        try {
            CommonsBlockHoundIntegration.allowPublicMethodsToBlock((BlockHound.Builder)builder, Class.forName(BasicComponentRegistryImpl.class.getName() + "$ComponentWrapper"));
        }
        catch (ClassNotFoundException e) {
            throw new CacheException((Throwable)e);
        }
        builder.allowBlockingCallsInside(ClusterTopologyManagerImpl.class.getName(), "updateState");
        builder.allowBlockingCallsInside(ClusterTopologyManagerImpl.class.getName(), "initCacheStatusIfAbsent");
        builder.allowBlockingCallsInside(LocalTopologyManagerImpl.class.getName(), "writeCHState");
        builder.allowBlockingCallsInside(LocalTopologyManagerImpl.class.getName(), "deleteCHState");
        builder.allowBlockingCallsInside(LocalTopologyManagerImpl.class.getName(), "getNumberMembersFromState");
        builder.allowBlockingCallsInside(CacheMgmtInterceptor.class.getName(), "getNumberOfEntries");
        builder.allowBlockingCallsInside(SerializationContextRegistryImpl.class.getName(), "register");
    }
}

