/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.impl;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.context.impl.FlagBitSets;

public final class ModificationList {
    private static final int DEFAULT_ARRAY_LENGTH = 16;
    @GuardedBy(value="this")
    private WriteCommand[] mods;
    @GuardedBy(value="this")
    private int nextInsertIndex;
    @GuardedBy(value="this")
    private int[] nonLocalIndexes;
    @GuardedBy(value="this")
    private int nextNonLocalInsertIndex;
    private volatile boolean frozen;

    public ModificationList() {
        this.mods = new WriteCommand[16];
        this.nonLocalIndexes = new int[16];
    }

    public ModificationList(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException("Capacity must be greater than 1 but is " + capacity);
        }
        this.mods = new WriteCommand[capacity];
        this.nonLocalIndexes = new int[capacity];
    }

    public static ModificationList fromCollection(Collection<WriteCommand> mods) {
        if (mods == null || mods.isEmpty()) {
            return new ModificationList();
        }
        ModificationList modificationList = new ModificationList(mods.size());
        for (WriteCommand command : mods) {
            modificationList.append(command);
        }
        return modificationList;
    }

    public synchronized void append(WriteCommand command) {
        this.checkNotFrozen();
        if (this.nextInsertIndex == this.mods.length) {
            this.growAllMods();
        }
        assert (this.nextInsertIndex < this.mods.length);
        if (!command.hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL)) {
            if (this.nextNonLocalInsertIndex == this.nonLocalIndexes.length) {
                this.growNonLocalIndexMap();
            }
            assert (this.nextNonLocalInsertIndex < this.nonLocalIndexes.length);
            this.nonLocalIndexes[this.nextNonLocalInsertIndex++] = this.nextInsertIndex;
        }
        this.mods[this.nextInsertIndex++] = command;
    }

    public void freeze() {
        this.frozen = true;
    }

    public synchronized List<WriteCommand> getModifications() {
        return new NonLocalModificationsList(this.mods, this.nonLocalIndexes, this.nextNonLocalInsertIndex);
    }

    public synchronized boolean hasNonLocalModifications() {
        return this.nextNonLocalInsertIndex != 0;
    }

    public synchronized List<WriteCommand> getAllModifications() {
        return new AllModsList(this.mods, this.nextInsertIndex);
    }

    public synchronized int size() {
        return this.nextInsertIndex;
    }

    public synchronized boolean isEmpty() {
        return this.nextInsertIndex == 0;
    }

    public synchronized String toString() {
        return "ModificationList{mods=" + Arrays.toString(this.mods) + "}";
    }

    private void checkNotFrozen() {
        if (this.frozen) {
            throw new IllegalStateException();
        }
    }

    @GuardedBy(value="this")
    private void growAllMods() {
        int newCapacity = this.mods.length == 1 ? 2 : this.mods.length + (this.mods.length >> 1);
        this.mods = Arrays.copyOf(this.mods, newCapacity);
    }

    @GuardedBy(value="this")
    private void growNonLocalIndexMap() {
        int newCapacity = this.nonLocalIndexes.length == 1 ? 2 : this.nonLocalIndexes.length + (this.nonLocalIndexes.length >> 1);
        this.nonLocalIndexes = Arrays.copyOf(this.nonLocalIndexes, newCapacity);
    }

    private static void checkIndex(int index, int size) {
        if (index < 0 || index >= size) {
            throw new ArrayIndexOutOfBoundsException("Range check failed: " + index + " not in [0," + size + "[.");
        }
    }

    private static class NonLocalModificationsList
    extends AbstractList<WriteCommand> {
        private final WriteCommand[] mods;
        private final int[] indexMappings;
        private final int size;

        private NonLocalModificationsList(WriteCommand[] mods, int[] indexMappings, int size) {
            this.mods = mods;
            this.indexMappings = indexMappings;
            this.size = size;
        }

        @Override
        public WriteCommand get(int index) {
            ModificationList.checkIndex(index, this.size);
            return this.mods[this.indexMappings[index]];
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    private static class AllModsList
    extends AbstractList<WriteCommand> {
        private final WriteCommand[] mods;
        private final int size;

        private AllModsList(WriteCommand[] mods, int size) {
            this.mods = mods;
            this.size = size;
        }

        @Override
        public WriteCommand get(int index) {
            ModificationList.checkIndex(index, this.size);
            return this.mods[index];
        }

        @Override
        public int size() {
            return this.size;
        }
    }
}

