/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.PersistentUUIDManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PersistentUUIDManagerImpl
implements PersistentUUIDManager {
    private static final Log log = LogFactory.getLog(PersistentUUIDManagerImpl.class);
    private final ConcurrentMap<Address, UUID> address2uuid = new ConcurrentHashMap<Address, UUID>();
    private final ConcurrentMap<UUID, Address> uuid2address = new ConcurrentHashMap<UUID, Address>();

    @Override
    public void addPersistentAddressMapping(Address address, UUID persistentUUID) {
        this.address2uuid.put(address, persistentUUID);
        this.uuid2address.put(persistentUUID, address);
    }

    @Override
    public UUID getPersistentUuid(Address address) {
        return (UUID)this.address2uuid.get(address);
    }

    @Override
    public Address getAddress(UUID persistentUUID) {
        return (Address)this.uuid2address.get(persistentUUID);
    }

    @Override
    public void removePersistentAddressMapping(UUID persistentUUID) {
        if (persistentUUID == null) {
            return;
        }
        Address address = (Address)this.uuid2address.get(persistentUUID);
        if (address != null) {
            this.address2uuid.remove(address);
            this.uuid2address.remove(persistentUUID);
        }
    }

    @Override
    public void removePersistentAddressMapping(Address address) {
        UUID uuid = (UUID)this.address2uuid.get(address);
        if (uuid != null) {
            this.uuid2address.remove(uuid);
            this.address2uuid.remove(address);
        }
    }

    @Override
    public List<UUID> mapAddresses(List<Address> addresses) {
        ArrayList<UUID> list = new ArrayList<UUID>(addresses.size());
        for (Address address : addresses) {
            UUID persistentUUID = (UUID)this.address2uuid.get(address);
            if (persistentUUID == null) {
                NullPointerException npe = new NullPointerException();
                log.fatal("Cannot find mapping for address " + String.valueOf(address), npe);
                throw npe;
            }
            list.add(persistentUUID);
        }
        return list;
    }

    @Override
    public Function<Address, UUID> addressToPersistentUUID() {
        return this.address2uuid::get;
    }

    @Override
    public Function<UUID, Address> persistentUUIDToAddress() {
        return this.uuid2address::get;
    }
}

