/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener.cluster;

import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.infinispan.Cache;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.ListenerHolder;
import org.infinispan.notifications.cachelistener.cluster.ClusterEventManager;
import org.infinispan.notifications.cachelistener.cluster.RemoteClusterListener;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterConverter;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.Address;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ProtoTypeId(value=1057)
public class ClusterListenerReplicateCallable<K, V>
implements Function<EmbeddedCacheManager, Void>,
BiConsumer<EmbeddedCacheManager, Cache<K, V>> {
    private static final Log log = LogFactory.getLog(ClusterListenerReplicateCallable.class);
    private final CacheEventFilter<K, V> filter;
    private final CacheEventConverter<K, V, ?> converter;
    @ProtoField(value=1)
    final UUID identifier;
    @ProtoField(value=2)
    final String cacheName;
    @ProtoField(value=3)
    final Address origin;
    @ProtoField(value=4)
    final boolean sync;
    @ProtoField(value=5)
    final Set<Class<? extends Annotation>> filterAnnotations;
    @ProtoField(value=6)
    final DataConversion keyDataConversion;
    @ProtoField(value=7)
    final DataConversion valueDataConversion;
    @ProtoField(value=8)
    final boolean useStorageFormat;

    public ClusterListenerReplicateCallable(String cacheName, UUID identifier, Address origin, CacheEventFilter<K, V> filter, CacheEventConverter<K, V, ?> converter, boolean sync, Set<Class<? extends Annotation>> filterAnnotations, DataConversion keyDataConversion, DataConversion valueDataConversion, boolean useStorageFormat) {
        this.cacheName = cacheName;
        this.identifier = identifier;
        this.origin = origin;
        this.filter = filter;
        this.converter = converter;
        this.sync = sync;
        this.filterAnnotations = filterAnnotations;
        this.keyDataConversion = keyDataConversion;
        this.valueDataConversion = valueDataConversion;
        this.useStorageFormat = useStorageFormat;
        if (log.isTraceEnabled()) {
            log.tracef("Created clustered listener replicate callable for: %s", filterAnnotations);
        }
    }

    @ProtoFactory
    static <K, V> ClusterListenerReplicateCallable<K, V> protoFactory(UUID identifier, String cacheName, Address origin, boolean sync, Set<Class<? extends Annotation>> filterAnnotations, DataConversion keyDataConversion, DataConversion valueDataConversion, boolean useStorageFormat, MarshallableObject<CacheEventFilter<K, V>> filter, MarshallableObject<CacheEventConverter<K, V, ?>> converter, boolean sameConverter) {
        CacheEventFilter<K, V> f = MarshallableObject.unwrap(filter);
        CacheEventConverter cec = sameConverter ? (CacheEventFilterConverter)f : MarshallableObject.unwrap(converter);
        return new ClusterListenerReplicateCallable<K, V>(cacheName, identifier, origin, f, cec, sync, filterAnnotations, keyDataConversion, valueDataConversion, useStorageFormat);
    }

    @ProtoField(value=9)
    MarshallableObject<CacheEventFilter<K, V>> getFilter() {
        return MarshallableObject.create(this.filter);
    }

    @ProtoField(value=10)
    MarshallableObject<CacheEventConverter<K, V, ?>> getConverter() {
        return this.isSameConverter() ? null : MarshallableObject.create(this.converter);
    }

    @ProtoField(value=11)
    boolean isSameConverter() {
        return this.filter == this.converter && this.filter instanceof CacheEventFilterConverter;
    }

    @Override
    public Void apply(EmbeddedCacheManager cacheManager) {
        Object cache = SecurityActions.getCache(cacheManager, this.cacheName);
        this.accept(cacheManager, (Cache<K, V>)cache);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(EmbeddedCacheManager cacheManager, Cache<K, V> cache) {
        ComponentRegistry componentRegistry = SecurityActions.getCacheComponentRegistry(cache.getAdvancedCache());
        CacheNotifier cacheNotifier = componentRegistry.getComponent(CacheNotifier.class);
        CacheManagerNotifier cacheManagerNotifier = componentRegistry.getComponent(CacheManagerNotifier.class);
        Address ourAddress = cache.getCacheManager().getAddress();
        ClusterEventManager eventManager = componentRegistry.getComponent(ClusterEventManager.class);
        if (this.filter != null) {
            componentRegistry.wireDependencies(this.filter);
        }
        if (this.converter != null && this.converter != this.filter) {
            componentRegistry.wireDependencies(this.converter);
        }
        if (!ourAddress.equals(this.origin)) {
            if (cacheManager.getMembers().contains(this.origin)) {
                CacheNotifier cacheNotifier2 = cacheNotifier;
                synchronized (cacheNotifier2) {
                    boolean alreadyInstalled = false;
                    for (Object installedListener : cacheNotifier.getListeners()) {
                        if (!(installedListener instanceof RemoteClusterListener) || !this.identifier.equals(((RemoteClusterListener)installedListener).getId())) continue;
                        alreadyInstalled = true;
                        break;
                    }
                    if (!alreadyInstalled) {
                        RemoteClusterListener listener = new RemoteClusterListener(this.identifier, this.origin, cacheNotifier, cacheManagerNotifier, eventManager, this.sync);
                        ListenerHolder listenerHolder = new ListenerHolder(listener, this.keyDataConversion, this.valueDataConversion, this.useStorageFormat);
                        cacheNotifier.addFilteredListener(listenerHolder, this.filter, this.converter, this.filterAnnotations);
                        cacheManagerNotifier.addListener(listener);
                        if (!cacheManager.getMembers().contains(this.origin)) {
                            cacheNotifier.removeListener(listener);
                            cacheManagerNotifier.removeListener(listener);
                            if (log.isTraceEnabled()) {
                                log.tracef("Removing local cluster listener for remote cluster listener that was just registered, as the origin %s went away concurrently", this.origin);
                            }
                        } else if (log.isTraceEnabled()) {
                            log.tracef("Registered local cluster listener for remote cluster listener from origin %s with id %s", this.origin, this.identifier);
                        }
                    } else if (log.isTraceEnabled()) {
                        log.tracef("Local cluster listener from origin %s with id %s was already installed, ignoring", this.origin, this.identifier);
                    }
                }
            } else if (log.isTraceEnabled()) {
                log.tracef("Not registering local cluster listener for remote cluster listener from origin %s, as the origin went away", this.origin);
            }
        } else if (log.isTraceEnabled()) {
            log.trace("Not registering local cluster listener as we are the node who registered the cluster listener");
        }
    }

    public String toString() {
        return "ClusterListenerReplicateCallable{cacheName='" + this.cacheName + "', identifier=" + String.valueOf(this.identifier) + ", origin=" + String.valueOf(this.origin) + ", sync=" + this.sync + "}";
    }
}

