/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.metadata.impl;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=1090)
public class InternalMetadataImpl
implements InternalMetadata {
    private final Metadata actual;
    private final long created;
    private final long lastUsed;

    @ProtoFactory
    InternalMetadataImpl(long created, long lastUsed, MarshallableObject<Metadata> wrappedMetadata) {
        this(MarshallableObject.unwrap(wrappedMetadata), created, lastUsed);
    }

    public InternalMetadataImpl(InternalCacheEntry<?, ?> ice) {
        this(ice.getMetadata(), ice.getCreated(), ice.getLastUsed());
    }

    public InternalMetadataImpl(Metadata actual, long created, long lastUsed) {
        this.actual = InternalMetadataImpl.extractMetadata(actual);
        this.created = created;
        this.lastUsed = lastUsed;
    }

    @Override
    public long lifespan() {
        return this.actual.lifespan();
    }

    @Override
    public long maxIdle() {
        return this.actual.maxIdle();
    }

    @Override
    public EntryVersion version() {
        return this.actual.version();
    }

    @Override
    public boolean isEmpty() {
        return this.actual.isEmpty();
    }

    @Override
    public Metadata.Builder builder() {
        return new InternalBuilder(this.actual, this.created, this.lastUsed);
    }

    @Override
    @ProtoField(value=1)
    public long created() {
        return this.created;
    }

    @Override
    @ProtoField(value=2)
    public long lastUsed() {
        return this.lastUsed;
    }

    public Metadata actual() {
        return this.actual;
    }

    @ProtoField(value=3)
    MarshallableObject<Metadata> getWrappedMetadata() {
        return MarshallableObject.create(this.actual);
    }

    @Override
    public long expiryTime() {
        long muet;
        long lifespan = this.actual.lifespan();
        long lset = lifespan > -1L ? this.created + lifespan : -1L;
        long maxIdle = this.actual.maxIdle();
        long l = muet = maxIdle > -1L ? this.lastUsed + maxIdle : -1L;
        if (lset == -1L) {
            return muet;
        }
        if (muet == -1L) {
            return lset;
        }
        return Math.min(lset, muet);
    }

    @Override
    public boolean isExpired(long now) {
        long expiry = this.expiryTime();
        return expiry > 0L && expiry <= now;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalMetadataImpl that = (InternalMetadataImpl)o;
        return this.created == that.created && this.lastUsed == that.lastUsed && Objects.equals(this.actual, that.actual);
    }

    public int hashCode() {
        return Objects.hash(this.actual, this.created, this.lastUsed);
    }

    public String toString() {
        return "InternalMetadataImpl{actual=" + String.valueOf(this.actual) + ", created=" + this.created + ", lastUsed=" + this.lastUsed + "}";
    }

    public static Metadata extractMetadata(Metadata metadata) {
        Metadata toCheck = metadata;
        while (toCheck != null && toCheck instanceof InternalMetadataImpl) {
            toCheck = ((InternalMetadataImpl)toCheck).actual();
        }
        return toCheck;
    }

    static class InternalBuilder
    implements Metadata.Builder {
        private Metadata.Builder actualBuilder;
        private final long created;
        private final long lastUsed;

        InternalBuilder(Metadata actual, long created, long lastUsed) {
            this.actualBuilder = actual != null ? actual.builder() : new EmbeddedMetadata.Builder();
            this.created = created;
            this.lastUsed = lastUsed;
        }

        @Override
        public Metadata.Builder lifespan(long time, TimeUnit unit) {
            this.actualBuilder = this.actualBuilder.lifespan(time, unit);
            return this;
        }

        @Override
        public Metadata.Builder lifespan(long time) {
            this.actualBuilder = this.actualBuilder.lifespan(time);
            return this;
        }

        @Override
        public Metadata.Builder maxIdle(long time, TimeUnit unit) {
            this.actualBuilder = this.actualBuilder.maxIdle(time, unit);
            return this;
        }

        @Override
        public Metadata.Builder maxIdle(long time) {
            this.actualBuilder = this.actualBuilder.maxIdle(time);
            return this;
        }

        @Override
        public Metadata.Builder version(EntryVersion version) {
            this.actualBuilder = this.actualBuilder.version(version);
            return this;
        }

        @Override
        public Metadata.Builder merge(Metadata metadata) {
            this.actualBuilder = this.actualBuilder.merge(metadata);
            return this;
        }

        @Override
        public Metadata build() {
            return new InternalMetadataImpl(this.actualBuilder.build(), this.created, this.lastUsed);
        }
    }
}

