/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.protostream.impl;

import java.io.IOException;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.marshall.protostream.impl.AbstractMarshallableWrapper;
import org.infinispan.marshall.protostream.impl.GlobalContextInitializer;
import org.infinispan.marshall.protostream.impl.GlobalMarshaller;
import org.infinispan.protostream.BaseMarshallerDelegate;
import org.infinispan.protostream.GeneratedMarshallerBase;
import org.infinispan.protostream.ProtobufTagMarshaller;
import org.infinispan.protostream.TagReader;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=22)
public class MarshallableObject<T>
extends AbstractMarshallableWrapper<T> {
    static final MarshallableObject<?> EMPTY_INSTANCE = new MarshallableObject<Object>(null);

    public static <T> MarshallableObject<T> create(T object) {
        return object == null ? null : new MarshallableObject<T>(object);
    }

    public static <T> T unwrap(MarshallableObject<T> wrapper) {
        return (T)(wrapper == null ? null : wrapper.get());
    }

    @ProtoFactory
    MarshallableObject(byte[] bytes, WrappedMessage message) {
        super(bytes);
    }

    public MarshallableObject(T object) {
        super(object);
    }

    @ProtoField(value=2)
    WrappedMessage getMessage() {
        throw log.marshallerNotOverridden(this.getClass().getName());
    }

    public static class Marshaller
    extends GeneratedMarshallerBase
    implements ProtobufTagMarshaller<MarshallableObject> {
        private final String typeName = GlobalContextInitializer.getFqTypeName(MarshallableObject.class);
        private final GlobalMarshaller marshaller;
        private volatile BaseMarshallerDelegate<WrappedMessage> delegate;

        public Marshaller(GlobalMarshaller marshaller) {
            this.marshaller = marshaller;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public Class<MarshallableObject> getJavaClass() {
            return MarshallableObject.class;
        }

        public MarshallableObject<?> read(ProtobufTagMarshaller.ReadContext ctx) throws IOException {
            TagReader in = ctx.getReader();
            WrappedMessage message = null;
            byte[] bytes = null;
            boolean done = false;
            block5: while (!done) {
                int tag = in.readTag();
                switch (tag) {
                    case 0: {
                        done = true;
                        continue block5;
                    }
                    case 10: {
                        bytes = in.readByteArray();
                        continue block5;
                    }
                    case 18: {
                        if (this.delegate == null) {
                            this.delegate = ctx.getSerializationContext().getMarshallerDelegate(WrappedMessage.class);
                        }
                        int length = in.readUInt32();
                        int oldLimit = in.pushLimit(length);
                        message = (WrappedMessage)this.readMessage(this.delegate, ctx);
                        in.checkLastTagWas(0);
                        in.popLimit(oldLimit);
                        continue block5;
                    }
                }
                if (in.skipField(tag)) continue;
                done = true;
            }
            if (bytes == null && message == null) {
                return EMPTY_INSTANCE;
            }
            if (message != null) {
                return new MarshallableObject<Object>(message.getValue());
            }
            Object userObject = this.marshaller.objectFromByteBuffer(bytes);
            return new MarshallableObject<Object>(userObject);
        }

        public void write(ProtobufTagMarshaller.WriteContext ctx, MarshallableObject wrapper) throws IOException {
            Object object = wrapper.get();
            if (object == null) {
                return;
            }
            if (!this.marshaller.isMarshallableWithoutWrapping(object)) {
                ByteBuffer buf = this.marshaller.objectToBuffer(object);
                ctx.getWriter().writeBytes(1, buf.getBuf(), buf.getOffset(), buf.getLength());
            } else {
                if (this.delegate == null) {
                    this.delegate = ctx.getSerializationContext().getMarshallerDelegate(WrappedMessage.class);
                }
                this.writeNestedMessage(this.delegate, ctx, 2, new WrappedMessage(object));
            }
        }
    }
}

