/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.protostream.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.marshall.protostream.impl.AbstractInternalProtoStreamMarshaller;
import org.infinispan.marshall.protostream.impl.GlobalContextInitializer;
import org.infinispan.protostream.GeneratedMarshallerBase;
import org.infinispan.protostream.ProtobufTagMarshaller;
import org.infinispan.protostream.TagReader;
import org.infinispan.protostream.TagWriter;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ProtoTypeId(value=16)
public class MarshallableArray<T> {
    static final Log log = LogFactory.getLog(MarshallableArray.class);
    private final T[] array;

    public static <T> MarshallableArray<T> create(T[] entries) {
        return entries == null ? null : new MarshallableArray<T>(entries);
    }

    public static <T> T[] unwrap(MarshallableArray<T> wrapper) {
        return wrapper == null ? null : wrapper.array;
    }

    public static <T> T[] unwrap(MarshallableArray<T> wrapper, T[] dest) {
        if (wrapper == null) {
            return null;
        }
        int size = wrapper.array.length;
        T[] array = wrapper.array;
        if (dest.length < size) {
            return Arrays.copyOf(array, size, dest.getClass());
        }
        System.arraycopy(array, 0, dest, 0, size);
        if (dest.length > size) {
            dest[size] = null;
        }
        return dest;
    }

    private MarshallableArray(T[] array) {
        this.array = array;
    }

    @ProtoFactory
    MarshallableArray(int size, List<byte[]> bytes) {
        throw log.marshallerNotOverridden(this.getClass().getName());
    }

    @ProtoField(value=1)
    int size() {
        throw log.marshallerNotOverridden(this.getClass().getName());
    }

    @ProtoField(value=2)
    List<byte[]> getBytes() {
        throw log.marshallerNotOverridden(this.getClass().getName());
    }

    public Object[] get() {
        return this.array;
    }

    public static class Marshaller
    extends GeneratedMarshallerBase
    implements ProtobufTagMarshaller<MarshallableArray> {
        private final String typeName = GlobalContextInitializer.getFqTypeName(MarshallableArray.class);
        private final AbstractInternalProtoStreamMarshaller marshaller;

        public Marshaller(AbstractInternalProtoStreamMarshaller marshaller) {
            this.marshaller = marshaller;
        }

        public MarshallableArray read(ProtobufTagMarshaller.ReadContext ctx) throws IOException {
            TagReader in = ctx.getReader();
            int tag = in.readTag();
            if (tag == 0) {
                return new MarshallableArray<Object>(new Object[0]);
            }
            if (tag != 8) {
                throw new IllegalStateException("Unexpected tag: " + tag);
            }
            int i = 0;
            int size = in.readInt32();
            Object[] entries = new Object[size];
            boolean done = false;
            block4: while (!done) {
                tag = in.readTag();
                switch (tag) {
                    case 0: {
                        done = true;
                        continue block4;
                    }
                    case 18: {
                        byte[] bytes = in.readByteArray();
                        entries[i++] = this.marshaller.objectFromByteBuffer(bytes);
                        continue block4;
                    }
                }
                if (in.skipField(tag)) continue;
                done = true;
            }
            return new MarshallableArray<Object>(entries);
        }

        public void write(ProtobufTagMarshaller.WriteContext ctx, MarshallableArray marshallableArray) throws IOException {
            Object[] array = marshallableArray.get();
            if (array != null && array.length > 0) {
                TagWriter writer = ctx.getWriter();
                writer.writeInt32(1, array.length);
                for (Object entry : array) {
                    ByteBuffer buf = this.marshaller.objectToBuffer(entry);
                    writer.writeBytes(2, buf.getBuf(), buf.getOffset(), buf.getLength());
                }
            }
        }

        public Class<? extends MarshallableArray> getJavaClass() {
            return MarshallableArray.class;
        }

        public String getTypeName() {
            return this.typeName;
        }
    }
}

