/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager.impl;

import java.util.concurrent.CompletionStage;
import javax.security.auth.Subject;
import org.infinispan.commands.GlobalRpcCommand;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.NodeVersion;
import org.infinispan.security.Security;
import org.infinispan.util.concurrent.BlockingManager;

@ProtoTypeId(value=1164)
public class ReplicableRunnableCommand
implements GlobalRpcCommand {
    final Runnable runnable;
    final Subject subject;

    public ReplicableRunnableCommand(Runnable runnable, Subject subject) {
        this.runnable = runnable;
        this.subject = subject;
    }

    @ProtoFactory
    ReplicableRunnableCommand(MarshallableObject<Runnable> runnable, Subject subject) {
        this.runnable = MarshallableObject.unwrap(runnable);
        this.subject = subject;
    }

    @ProtoField(value=1)
    MarshallableObject<Runnable> getRunnable() {
        return MarshallableObject.create(this.runnable);
    }

    @ProtoField(value=2)
    Subject getSubject() {
        return this.subject;
    }

    @Override
    public CompletionStage<?> invokeAsync(GlobalComponentRegistry globalComponentRegistry) throws Throwable {
        BlockingManager bm = globalComponentRegistry.getComponent(BlockingManager.class);
        return bm.supplyBlocking(() -> {
            if (this.subject == null) {
                this.runnable.run();
            } else {
                Security.doAs(this.subject, this.runnable);
            }
            return null;
        }, "replicable-runnable").toCompletableFuture();
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public NodeVersion supportedSince() {
        return NodeVersion.SIXTEEN;
    }
}

