/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.commons.marshall.ImmutableProtoStreamMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.StreamAwareMarshaller;
import org.infinispan.factories.AbstractComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.marshall.core.impl.DelegatingUserMarshaller;
import org.infinispan.marshall.persistence.impl.PersistenceMarshallerImpl;
import org.infinispan.marshall.protostream.impl.GlobalMarshaller;
import org.infinispan.marshall.protostream.impl.SerializationContextRegistry;

@DefaultFactoryFor(classes={Marshaller.class, StreamAwareMarshaller.class}, names={"org.infinispan.marshaller.internal", "org.infinispan.marshaller.persistence", "org.infinispan.marshaller.user"})
public class MarshallerFactory
extends AbstractComponentFactory
implements AutoInstantiableFactory {
    @Inject
    ComponentRef<SerializationContextRegistry> contextRegistry;

    @Override
    public Object construct(String componentName) {
        switch (componentName) {
            case "org.infinispan.marshaller.persistence": {
                return new PersistenceMarshallerImpl();
            }
            case "org.infinispan.marshaller.internal": {
                return new GlobalMarshaller();
            }
            case "org.infinispan.marshaller.user": {
                Marshaller marshaller = this.globalConfiguration.serialization().marshaller();
                if (marshaller != null) {
                    marshaller.initialize(this.globalComponentRegistry.getCacheManager().getClassAllowList());
                } else {
                    marshaller = new ImmutableProtoStreamMarshaller(this.contextRegistry.wired().getUserCtx());
                }
                return new DelegatingUserMarshaller(marshaller);
            }
        }
        throw new IllegalArgumentException(String.format("Marshaller name '%s' not recognised", componentName));
    }
}

