/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.infinispan.commands.AbstractTopologyAffectedCommand;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.MetadataAwareCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.Util;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.marshall.protostream.impl.MarshallableMap;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.NodeVersion;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.locks.RemoteLockCommand;

@ProtoTypeId(value=1148)
public class PutMapCommand
extends AbstractTopologyAffectedCommand
implements WriteCommand,
MetadataAwareCommand,
RemoteLockCommand {
    private Map<Object, Object> map;
    private Metadata metadata;
    private boolean isForwarded = false;
    private CommandInvocationId commandInvocationId;
    private Map<Object, PrivateMetadata> internalMetadataMap;

    public PutMapCommand(ByteString cacheName, Map<?, ?> map, Metadata metadata, long flagsBitSet, CommandInvocationId commandInvocationId) {
        super(cacheName, flagsBitSet, -1);
        this.map = map;
        this.metadata = metadata;
        this.commandInvocationId = commandInvocationId;
        this.internalMetadataMap = new HashMap<Object, PrivateMetadata>();
    }

    public PutMapCommand(PutMapCommand c) {
        this(c.cacheName, c.map, c.metadata, c.flags, c.commandInvocationId);
        this.isForwarded = c.isForwarded;
        this.internalMetadataMap = new HashMap<Object, PrivateMetadata>(c.internalMetadataMap);
    }

    @ProtoFactory
    PutMapCommand(ByteString cacheName, long flagsWithoutRemote, int topologyId, MarshallableMap<Object, Object> wrappedMap, MarshallableObject<Metadata> wrappedMetadata, boolean forwarded, CommandInvocationId commandInvocationId, MarshallableMap<Object, PrivateMetadata> internalMetadata) {
        super(cacheName, flagsWithoutRemote, topologyId);
        this.map = MarshallableMap.unwrap(wrappedMap);
        this.metadata = MarshallableObject.unwrap(wrappedMetadata);
        this.isForwarded = forwarded;
        this.commandInvocationId = commandInvocationId;
        this.internalMetadataMap = MarshallableMap.unwrap(internalMetadata);
    }

    @ProtoField(number=4, name="map")
    MarshallableMap<Object, Object> getWrappedMap() {
        return MarshallableMap.create(this.map);
    }

    @ProtoField(number=5, name="metadata")
    MarshallableObject<Metadata> getWrappedMetadata() {
        return MarshallableObject.create(this.metadata);
    }

    @Override
    @ProtoField(value=6)
    public CommandInvocationId getCommandInvocationId() {
        return this.commandInvocationId;
    }

    @ProtoField(value=7)
    public boolean isForwarded() {
        return this.isForwarded;
    }

    @ProtoField(value=8)
    MarshallableMap<Object, PrivateMetadata> getInternalMetadata() {
        return MarshallableMap.create(this.internalMetadataMap);
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitPutMapCommand(ctx, this);
    }

    @Override
    public Collection<?> getKeysToLock() {
        return this.isForwarded ? Collections.emptyList() : Collections.unmodifiableCollection(this.map.keySet());
    }

    @Override
    public Object getKeyLockOwner() {
        return this.commandInvocationId;
    }

    @Override
    public boolean hasZeroLockAcquisition() {
        return this.hasAnyFlag(FlagBitSets.ZERO_LOCK_ACQUISITION_TIMEOUT);
    }

    @Override
    public boolean hasSkipLocking() {
        return this.hasAnyFlag(FlagBitSets.SKIP_LOCKING);
    }

    public Map<Object, Object> getMap() {
        return this.map;
    }

    public void setMap(Map<Object, Object> map) {
        this.map = map;
        this.internalMetadataMap.keySet().retainAll(map.keySet());
    }

    public final PutMapCommand withMap(Map<Object, Object> map) {
        this.setMap(map);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PutMapCommand that = (PutMapCommand)o;
        return Objects.equals(this.metadata, that.metadata) && Objects.equals(this.map, that.map);
    }

    public int hashCode() {
        return Objects.hash(this.map, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PutMapCommand{map={");
        if (!this.map.isEmpty()) {
            Iterator<Map.Entry<Object, Object>> it = this.map.entrySet().iterator();
            int i = 0;
            while (true) {
                Map.Entry<Object, Object> e = it.next();
                sb.append(Util.toStr((Object)e.getKey())).append('=').append(Util.toStr((Object)e.getValue()));
                if (!it.hasNext()) break;
                if (i > 100) {
                    sb.append(" ...");
                    break;
                }
                sb.append(", ");
                ++i;
            }
        }
        sb.append("}, flags=").append(this.printFlags()).append(", metadata=").append(this.metadata).append(", internalMetadata=").append(this.internalMetadataMap).append(", isForwarded=").append(this.isForwarded).append(", topologyId=").append(this.getTopologyId()).append("}");
        return sb.toString();
    }

    @Override
    public boolean isSuccessful() {
        return true;
    }

    @Override
    public boolean isConditional() {
        return false;
    }

    @Override
    public ValueMatcher getValueMatcher() {
        return ValueMatcher.MATCH_ALWAYS;
    }

    @Override
    public void setValueMatcher(ValueMatcher valueMatcher) {
    }

    @Override
    public Collection<?> getAffectedKeys() {
        return this.map.keySet();
    }

    @Override
    public void fail() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isReturnValueExpected() {
        return !this.hasAnyFlag(FlagBitSets.IGNORE_RETURN_VALUES);
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return this.hasAnyFlag(FlagBitSets.IGNORE_RETURN_VALUES) ? VisitableCommand.LoadType.DONT_LOAD : VisitableCommand.LoadType.PRIMARY;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public void setForwarded(boolean forwarded) {
        this.isForwarded = forwarded;
    }

    @Override
    public PrivateMetadata getInternalMetadata(Object key) {
        return this.internalMetadataMap.get(key);
    }

    @Override
    public void setInternalMetadata(Object key, PrivateMetadata internalMetadata) {
        this.internalMetadataMap.put(key, internalMetadata);
    }

    @Override
    public NodeVersion supportedSince() {
        return NodeVersion.SIXTEEN;
    }
}

