/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.util.concurrent.CompletionStage;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.marshall.protostream.impl.MarshallableThrowable;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.NodeVersion;
import org.infinispan.remoting.transport.ResponseCollectors;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CommandAckCollector;

@ProtoTypeId(value=1077)
public class ExceptionAckCommand
extends BaseRpcCommand {
    @ProtoField(value=2)
    final long id;
    @ProtoField(value=3)
    final int topologyId;
    private final Throwable throwable;

    public ExceptionAckCommand(ByteString cacheName, long id, Throwable throwable, int topologyId) {
        super(cacheName);
        this.id = id;
        this.topologyId = topologyId;
        this.throwable = throwable;
    }

    @ProtoFactory
    ExceptionAckCommand(ByteString cacheName, long id, int topologyId, MarshallableThrowable throwable) {
        this(cacheName, id, throwable.get(), topologyId);
    }

    @ProtoField(value=4)
    MarshallableThrowable getThrowable() {
        return MarshallableThrowable.create(this.throwable);
    }

    public void ack(CommandAckCollector ackCollector) {
        CacheException remoteException = ResponseCollectors.wrapRemoteException(this.getOrigin(), this.throwable);
        ackCollector.completeExceptionally(this.id, (Throwable)remoteException, this.topologyId);
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public NodeVersion supportedSince() {
        return NodeVersion.SIXTEEN;
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry registry) throws Throwable {
        throw new UnsupportedOperationException("Should not happen");
    }

    @Override
    public String toString() {
        return "ExceptionAckCommand{id=" + this.id + ", throwable=" + String.valueOf(this.throwable) + ", topologyId=" + this.topologyId + "}";
    }
}

