/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.tx;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.tx.AbstractTransactionBoundaryCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.metadata.impl.IracMetadata;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.NodeVersion;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.ByteString;
import org.infinispan.util.logging.Log;

@ProtoTypeId(value=1061)
public class CommitCommand
extends AbstractTransactionBoundaryCommand {
    private Map<Integer, IracMetadata> iracMetadataMap;

    public CommitCommand(ByteString cacheName, GlobalTransaction globalTransaction) {
        super(cacheName, globalTransaction);
    }

    @ProtoFactory
    CommitCommand(int topologyId, ByteString cacheName, GlobalTransaction globalTransaction, Map<Integer, IracMetadata> iracMetadataMap) {
        super(topologyId, cacheName, globalTransaction);
        this.iracMetadataMap = iracMetadataMap;
    }

    @ProtoField(value=4)
    Map<Integer, IracMetadata> getIracMetadataMap() {
        return this.iracMetadataMap;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitCommitCommand((TxInvocationContext)ctx, this);
    }

    @Override
    protected Object invalidRemoteTxReturnValue(TransactionTable txTable) {
        TransactionTable.CompletedTransactionStatus txStatus = txTable.getCompletedTransactionStatus(this.globalTx);
        switch (txStatus) {
            case COMMITTED: {
                return null;
            }
            case ABORTED: {
                throw Log.CONTAINER.remoteTransactionAlreadyRolledBack(this.globalTx);
            }
            case EXPIRED: {
                throw Log.CONTAINER.remoteTransactionStatusMissing(this.globalTx);
            }
        }
        throw new IllegalStateException("Remote transaction not found: " + String.valueOf(this.globalTx));
    }

    @Override
    public NodeVersion supportedSince() {
        return NodeVersion.SIXTEEN;
    }

    @Override
    public String toString() {
        return "CommitCommand{iracMetadataMap=" + String.valueOf(this.iracMetadataMap) + ", " + super.toString();
    }

    public void addIracMetadata(int segment, IracMetadata metadata) {
        if (this.iracMetadataMap == null) {
            this.iracMetadataMap = new HashMap<Integer, IracMetadata>();
        }
        this.iracMetadataMap.put(segment, metadata);
    }

    public IracMetadata getIracMetadata(int segment) {
        return this.iracMetadataMap != null ? this.iracMetadataMap.get(segment) : null;
    }
}

