/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.irac;

import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.irac.BaseIracCommand;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.container.versioning.irac.IracEntryVersion;
import org.infinispan.container.versioning.irac.IracVersionGenerator;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.NodeVersion;
import org.infinispan.util.ByteString;

@ProtoTypeId(value=1112)
public class IracUpdateVersionCommand
extends BaseIracCommand {
    @ProtoField(value=2)
    final Map<Integer, IracEntryVersion> versions;

    @ProtoFactory
    public IracUpdateVersionCommand(ByteString cacheName, Map<Integer, IracEntryVersion> versions) {
        super(cacheName);
        this.versions = versions;
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry registry) throws Throwable {
        IracVersionGenerator versionGenerator = registry.getIracVersionGenerator().running();
        this.versions.forEach(versionGenerator::updateVersion);
        return CompletableFutures.completedNull();
    }

    @Override
    public NodeVersion supportedSince() {
        return NodeVersion.SIXTEEN;
    }

    public String toString() {
        return "IracUpdateVersionCommand{cacheName=" + String.valueOf(this.cacheName) + ", versions=" + String.valueOf(this.versions) + "}";
    }
}

