/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.metrics.impl;

import java.util.Collection;
import java.util.Set;
import org.infinispan.commons.stat.MetricInfo;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.metrics.impl.AbstractMetricsRegistration;
import org.infinispan.metrics.impl.NameUtils;

@Scope(value=Scopes.NAMED_CACHE)
@SurvivesRestarts
public final class CacheMetricsRegistration
extends AbstractMetricsRegistration {
    @Inject
    Configuration cacheConfiguration;
    @ComponentName(value="cacheName")
    @Inject
    String cacheName;

    @Override
    public boolean metricsEnabled() {
        return this.metricsCollector != null && this.cacheConfiguration.statistics().enabled();
    }

    @Override
    @Deprecated(forRemoval=true, since="16.0")
    protected String initLegacyNamePrefix() {
        Object prefix = super.initLegacyNamePrefix();
        if (!this.globalConfig.metrics().namesAsTags()) {
            prefix = (String)prefix + "cache_" + NameUtils.filterIllegalChars(this.cacheName) + "_";
        }
        return prefix;
    }

    @Override
    protected Set<Object> internalRegisterMetrics(Object instance, Collection<MetricInfo> metrics, String metricPrefix) {
        return this.metricsCollector.registerMetrics(instance, metrics, metricPrefix, this.cacheName);
    }
}

