/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import com.google.errorprone.annotations.ThreadSafe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.MBeanServerFactory;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.Version;
import org.infinispan.configuration.ConfigurationManager;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.ShutdownHookBehavior;
import org.infinispan.conflict.EntryMergePolicyFactoryRegistry;
import org.infinispan.factories.AbstractComponentRegistry;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.globalstate.GlobalConfigurationManager;
import org.infinispan.jmx.CacheManagerJmxRegistration;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.ModuleRepository;
import org.infinispan.manager.impl.InternalCacheManager;
import org.infinispan.metrics.impl.CacheManagerMetricsRegistration;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifierImpl;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.registry.impl.InternalCacheRegistryImpl;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.stats.ClusterContainerStats;
import org.infinispan.stats.ContainerStats;
import org.infinispan.topology.ClusterTopologyManager;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.util.ByteString;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.util.logging.events.EventLogManager;
import org.infinispan.xsite.GlobalXSiteAdminOperations;
import org.infinispan.xsite.XSiteCacheMapper;
import org.infinispan.xsite.events.XSiteEventsManager;

@ThreadSafe
@Scope(value=Scopes.GLOBAL)
@SurvivesRestarts
public class GlobalComponentRegistry
extends AbstractComponentRegistry {
    private static final Log log = LogFactory.getLog(GlobalComponentRegistry.class);
    private static final AtomicBoolean versionLogged = new AtomicBoolean(false);
    private Thread shutdownHook;
    private boolean invokedFromShutdownHook;
    private final GlobalConfiguration globalConfiguration;
    private final EmbeddedCacheManager cacheManager;
    private final Set<String> createdCaches;
    final Collection<ModuleLifecycle> moduleLifecycles;
    private final ConcurrentMap<ByteString, ComponentRegistry> namedComponents = new ConcurrentHashMap<ByteString, ComponentRegistry>(4);
    protected final ClassLoader classLoader;
    ComponentRef<ClusterTopologyManager> clusterTopologyManager;
    ComponentRef<LocalTopologyManager> localTopologyManager;

    public GlobalComponentRegistry(GlobalConfiguration configuration, EmbeddedCacheManager cacheManager, Set<String> createdCaches, ModuleRepository moduleRepository, ConfigurationManager configurationManager) {
        super(moduleRepository, true, null);
        ClassLoader configuredClassLoader = configuration.classLoader();
        this.moduleLifecycles = moduleRepository.getModuleLifecycles();
        this.classLoader = configuredClassLoader;
        try {
            this.globalConfiguration = configuration;
            this.registerComponent((Object)this, GlobalComponentRegistry.class);
            this.registerComponent((Object)configuration, GlobalConfiguration.class);
            this.registerComponent((Object)cacheManager, EmbeddedCacheManager.class);
            this.basicComponentRegistry.registerComponent(ConfigurationManager.class.getName(), configurationManager, true);
            this.basicComponentRegistry.registerComponent(CacheManagerJmxRegistration.class.getName(), new CacheManagerJmxRegistration(), true);
            this.basicComponentRegistry.registerComponent(CacheManagerMetricsRegistration.class.getName(), new CacheManagerMetricsRegistration(), true);
            this.basicComponentRegistry.registerComponent(CacheManagerNotifier.class.getName(), new CacheManagerNotifierImpl(), true);
            this.basicComponentRegistry.registerComponent(InternalCacheRegistry.class.getName(), new InternalCacheRegistryImpl(), true);
            this.basicComponentRegistry.registerComponent(EntryMergePolicyFactoryRegistry.class.getName(), new EntryMergePolicyFactoryRegistry(), true);
            this.basicComponentRegistry.registerComponent(GlobalXSiteAdminOperations.class.getName(), new GlobalXSiteAdminOperations(), true);
            this.basicComponentRegistry.registerComponent(ModuleInitializer.class, new ModuleInitializer(), true);
            this.createdCaches = createdCaches;
            this.cacheManager = cacheManager;
            this.basicComponentRegistry.getComponent(EventLogManager.class);
            this.basicComponentRegistry.getComponent(Transport.class);
            this.basicComponentRegistry.getComponent(ClusterContainerStats.class);
            this.basicComponentRegistry.getComponent(ContainerStats.class);
            this.basicComponentRegistry.getComponent(GlobalConfigurationManager.class);
            this.basicComponentRegistry.getComponent(CacheManagerJmxRegistration.class);
            this.basicComponentRegistry.getComponent(CacheManagerMetricsRegistration.class);
            this.basicComponentRegistry.getComponent(XSiteEventsManager.class);
            this.basicComponentRegistry.getComponent("org.infinispan.executors.timeout", ScheduledExecutorService.class);
            this.cacheComponents();
        }
        catch (Exception e) {
            throw new CacheException("Unable to construct a GlobalComponentRegistry!", (Throwable)e);
        }
    }

    private void cacheComponents() {
        this.localTopologyManager = this.basicComponentRegistry.getComponent(LocalTopologyManager.class);
        this.clusterTopologyManager = this.basicComponentRegistry.getComponent(ClusterTopologyManager.class);
    }

    @Override
    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected synchronized void removeShutdownHook() {
        if (!this.invokedFromShutdownHook && this.shutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
    }

    @Override
    public TimeService getTimeService() {
        return this.getOrCreateComponent(TimeService.class);
    }

    public <T extends ModuleLifecycle> T getModuleLifecycle(Class<T> type) {
        for (ModuleLifecycle module : this.moduleLifecycles) {
            if (!type.isInstance(module)) continue;
            return (T)module;
        }
        return null;
    }

    private boolean isMBeanServerRunning() {
        return !MBeanServerFactory.findMBeanServer(null).isEmpty();
    }

    @Override
    protected synchronized void addShutdownHook() {
        boolean registerShutdownHook;
        ShutdownHookBehavior shutdownHookBehavior = this.globalConfiguration.shutdown().hookBehavior();
        boolean bl = registerShutdownHook = shutdownHookBehavior == ShutdownHookBehavior.DEFAULT && !this.isMBeanServerRunning() || shutdownHookBehavior == ShutdownHookBehavior.REGISTER;
        if (registerShutdownHook) {
            log.tracef("Registering a shutdown hook.  Configured behavior = %s", (Object)shutdownHookBehavior);
            this.shutdownHook = new Thread(() -> {
                try {
                    this.invokedFromShutdownHook = true;
                    this.cacheManager.stop();
                }
                finally {
                    this.invokedFromShutdownHook = false;
                }
            });
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        } else {
            log.tracef("Not registering a shutdown hook.  Configured behavior = %s", (Object)shutdownHookBehavior);
        }
    }

    public final Collection<ComponentRegistry> getNamedComponentRegistries() {
        return new ArrayList<ComponentRegistry>(this.namedComponents.values());
    }

    public final ComponentRegistry getNamedComponentRegistry(String name) {
        return this.getNamedComponentRegistry(ByteString.fromString(name));
    }

    public final ComponentRegistry getNamedComponentRegistry(ByteString name) {
        return (ComponentRegistry)this.namedComponents.get(name);
    }

    public final synchronized void registerNamedComponentRegistry(ComponentRegistry componentRegistry, String name) {
        this.namedComponents.put(ByteString.fromString(name), componentRegistry);
    }

    public final synchronized void unregisterNamedComponentRegistry(String name) {
        this.namedComponents.remove(ByteString.fromString(name));
    }

    public final synchronized void rewireNamedRegistries() {
        for (ComponentRegistry cr : this.namedComponents.values()) {
            cr.rewire();
        }
    }

    @Override
    public void rewire() {
        super.rewire();
        this.cacheComponents();
    }

    @Override
    protected String getName() {
        return "DefaultCacheManager";
    }

    @Override
    protected void preStart() {
        this.basicComponentRegistry.getComponent(ModuleInitializer.class).running();
        if (versionLogged.compareAndSet(false, true)) {
            Log.CONTAINER.version(Version.printVersion());
        }
        this.basicComponentRegistry.getComponent(XSiteEventsManager.class).running();
    }

    @Override
    public void postStart() {
        this.modulesManagerStarted();
    }

    @Override
    protected CompletionStage<Void> delayStart() {
        return null;
    }

    private void modulesManagerStarting() {
        for (ModuleLifecycle l : this.moduleLifecycles) {
            if (log.isTraceEnabled()) {
                log.tracef("Invoking %s.cacheManagerStarting()", l);
            }
            l.cacheManagerStarting(this, this.globalConfiguration);
        }
    }

    private void modulesManagerStarted() {
        for (ModuleLifecycle l : this.moduleLifecycles) {
            if (this.state != ComponentStatus.RUNNING || this.cacheManager.getStatus().isStopping()) {
                log.tracef("Registry was shut down while performing postStart, ignoring remainder of moduleLifecycle instances.", new Object[0]);
                break;
            }
            if (log.isTraceEnabled()) {
                log.tracef("Invoking %s.cacheManagerStarted()", l);
            }
            l.cacheManagerStarted(this);
        }
    }

    @Override
    protected void preStop() {
        this.modulesManagerStopping();
    }

    @Override
    protected void postStop() {
    }

    private void modulesManagerStopping() {
        for (ModuleLifecycle l : this.moduleLifecycles) {
            if (log.isTraceEnabled()) {
                log.tracef("Invoking %s.cacheManagerStopping()", l);
            }
            try {
                l.cacheManagerStopping(this);
            }
            catch (Throwable t) {
                Log.CONTAINER.moduleStopError(l.getClass().getName(), t);
            }
        }
    }

    private void modulesManagerStopped() {
        if (this.state == ComponentStatus.TERMINATED) {
            for (ModuleLifecycle l : this.moduleLifecycles) {
                if (log.isTraceEnabled()) {
                    log.tracef("Invoking %s.cacheManagerStopped()", l);
                }
                try {
                    l.cacheManagerStopped(this);
                }
                catch (Throwable t) {
                    Log.CONTAINER.moduleStopError(l.getClass().getName(), t);
                }
            }
        }
    }

    public void notifyCacheStarted(String cacheName) {
        ComponentRegistry cr = this.getNamedComponentRegistry(cacheName);
        for (ModuleLifecycle l : this.moduleLifecycles) {
            if (log.isTraceEnabled()) {
                log.tracef("Invoking %s.cacheStarted()", l);
            }
            l.cacheStarted(cr, cacheName);
        }
    }

    public final GlobalConfiguration getGlobalConfiguration() {
        return this.globalConfiguration;
    }

    public synchronized boolean removeCache(String cacheName) {
        return this.createdCaches.remove(cacheName);
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public ClusterTopologyManager getClusterTopologyManager() {
        return this.clusterTopologyManager.running();
    }

    public LocalTopologyManager getLocalTopologyManager() {
        return this.localTopologyManager.running();
    }

    public XSiteCacheMapper getXSiteCacheMapper() {
        return this.basicComponentRegistry.getComponent(XSiteCacheMapper.class).running();
    }

    public static GlobalComponentRegistry of(EmbeddedCacheManager cacheManager) {
        return InternalCacheManager.of(cacheManager);
    }

    public static <T> T componentOf(EmbeddedCacheManager cacheManager, Class<T> type) {
        return GlobalComponentRegistry.of(cacheManager).getComponent(type);
    }

    public <T> void ensureComponentRunning(Class<T> type) {
        ComponentRef<T> ref = Objects.requireNonNull(this.basicComponentRegistry.getComponent(type));
        T t = ref.running();
        if (t == null || !ref.isRunning()) {
            throw new IllegalStateException(String.format("Component '%s' expected to be running", ref.getName()));
        }
    }

    @Scope(value=Scopes.GLOBAL)
    public class ModuleInitializer {
        @Start
        void start() {
            GlobalComponentRegistry.this.modulesManagerStarting();
        }

        @Stop
        void stop() {
            GlobalComponentRegistry.this.modulesManagerStopped();
        }
    }
}

