/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.encoding;

import java.util.Objects;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.commons.dataconversion.Wrapper;
import org.infinispan.encoding.impl.DataConversionInternal;
import org.infinispan.encoding.impl.StorageConfigurationManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoReserved;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=1066)
@ProtoReserved(numbers={2, 3}, names={"encoderId", "wrapperId"})
@Scope(value=Scopes.NONE)
public final class DataConversion {
    private final MediaType requestMediaType;
    private final boolean isKey;
    private transient MediaType storageMediaType;
    private transient Transcoder transcoder;
    private transient EncoderRegistry encoderRegistry;
    private transient StorageConfigurationManager storageConfigurationManager;

    private DataConversion(MediaType requestMediaType, boolean isKey) {
        this.requestMediaType = requestMediaType;
        this.isKey = isKey;
    }

    public DataConversion(boolean isKey) {
        this.isKey = isKey;
        this.storageMediaType = MediaType.APPLICATION_OBJECT;
        this.requestMediaType = MediaType.APPLICATION_OBJECT;
    }

    @ProtoFactory
    static DataConversion protoFactory(boolean isKey, MediaType mediaType) {
        return new DataConversion(mediaType, isKey);
    }

    @ProtoField(value=1)
    boolean getIsKey() {
        return this.isKey;
    }

    @ProtoField(value=4)
    MediaType getMediaType() {
        return this.requestMediaType;
    }

    public DataConversion withRequestMediaType(MediaType requestMediaType) {
        if (Objects.equals(this.requestMediaType, requestMediaType)) {
            return this;
        }
        return new DataConversion(requestMediaType, this.isKey);
    }

    @Inject
    void injectDependencies(StorageConfigurationManager storageConfigurationManager, EncoderRegistry encoderRegistry) {
        if (this == DataConversionInternal.IDENTITY_KEY || this == DataConversionInternal.IDENTITY_VALUE) {
            return;
        }
        this.storageMediaType = storageConfigurationManager.getStorageMediaType(this.isKey);
        this.encoderRegistry = encoderRegistry;
        this.storageConfigurationManager = storageConfigurationManager;
        this.lookupTranscoder();
    }

    private void lookupTranscoder() {
        boolean needsTranscoding;
        boolean bl = needsTranscoding = this.storageMediaType != null && this.requestMediaType != null && !this.requestMediaType.matchesAll() && !this.requestMediaType.equals((Object)this.storageMediaType);
        if (needsTranscoding) {
            this.transcoder = this.encoderRegistry.getTranscoder(this.requestMediaType, this.storageMediaType);
        }
    }

    public Object fromStorage(Object stored) {
        if (stored == null) {
            return null;
        }
        Object fromStorage = this.unwrap(stored);
        return this.transcoder == null ? fromStorage : this.transcoder.transcode(fromStorage, this.storageMediaType, this.requestMediaType);
    }

    public Object toStorage(Object toStore) {
        if (toStore == null) {
            return null;
        }
        toStore = this.transcoder == null ? toStore : this.transcoder.transcode(toStore, this.requestMediaType, this.storageMediaType);
        return this.wrap(toStore);
    }

    public Object extractIndexable(Object stored, boolean javaEmbeddedEntities) {
        if (stored == null) {
            return null;
        }
        if (this.isKey) {
            return this.unwrap(stored);
        }
        Wrapper wrapper = this.storageConfigurationManager.getWrapper(false);
        if (wrapper.isFilterable() && !javaEmbeddedEntities) {
            return stored.getClass() == wrapper.getClass() ? stored : wrapper.wrap(stored);
        }
        Object unencoded = this.unwrap(stored);
        return this.transcoder == null ? unencoded : this.transcoder.transcode(unencoded, this.storageMediaType, this.requestMediaType);
    }

    public MediaType getRequestMediaType() {
        return this.requestMediaType;
    }

    public MediaType getStorageMediaType() {
        return this.storageMediaType;
    }

    public Object wrap(Object o) {
        if (this.storageConfigurationManager != null) {
            return this.storageConfigurationManager.getWrapper(this.isKey).wrap(o);
        }
        return o;
    }

    public Object unwrap(Object o) {
        if (this.storageConfigurationManager != null) {
            return this.storageConfigurationManager.getWrapper(this.isKey).unwrap(o);
        }
        return o;
    }

    public static DataConversion newKeyDataConversion() {
        return new DataConversion(MediaType.APPLICATION_OBJECT, true);
    }

    public static DataConversion newValueDataConversion() {
        return new DataConversion(MediaType.APPLICATION_OBJECT, false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataConversion that = (DataConversion)o;
        return this.isKey == that.isKey && Objects.equals(this.transcoder, that.transcoder) && Objects.equals(this.requestMediaType, that.requestMediaType);
    }

    public String toString() {
        return "DataConversion@" + System.identityHashCode(this) + "{requestMediaType=" + String.valueOf(this.requestMediaType) + ", storageMediaType=" + String.valueOf(this.storageMediaType) + ", isKey=" + this.isKey + ", transcoder=" + String.valueOf(this.transcoder) + "}";
    }

    public int hashCode() {
        return Objects.hash(this.requestMediaType, this.isKey);
    }
}

