/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.triangle;

import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.functional.AbstractWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.triangle.FunctionalBackupWriteCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.encoding.DataConversion;
import org.infinispan.functional.impl.Params;
import org.infinispan.marshall.protostream.impl.MarshallableCollection;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.NodeVersion;
import org.infinispan.util.ByteString;

@ProtoTypeId(value=1137)
public class MultiKeyFunctionalBackupWriteCommand
extends FunctionalBackupWriteCommand {
    private boolean writeOnly;
    private Collection<?> keys;

    public static <K, V> MultiKeyFunctionalBackupWriteCommand create(ByteString cacheName, WriteOnlyManyCommand<K, V> command, Collection<?> keys, long sequence, int segmentId) {
        return new MultiKeyFunctionalBackupWriteCommand(cacheName, command, sequence, segmentId, command.getConsumer(), true, keys);
    }

    public static <K, V, R> MultiKeyFunctionalBackupWriteCommand create(ByteString cacheName, ReadWriteManyCommand<K, V, R> command, Collection<?> keys, long sequence, int segmentId) {
        return new MultiKeyFunctionalBackupWriteCommand(cacheName, command, sequence, segmentId, command.getFunction(), false, keys);
    }

    private MultiKeyFunctionalBackupWriteCommand(ByteString cacheName, AbstractWriteManyCommand<?, ?> command, long sequence, int segmentId, Object function, boolean writeOnly, Collection<?> keys) {
        super(cacheName, command, sequence, segmentId, function);
        this.writeOnly = writeOnly;
        this.keys = keys;
    }

    @ProtoFactory
    MultiKeyFunctionalBackupWriteCommand(ByteString cacheName, CommandInvocationId commandInvocationId, int topologyId, long flags, long sequence, int segmentId, MarshallableObject<?> function, Params params, DataConversion keyDataConversion, DataConversion valueDataConversion, boolean writeOnly, MarshallableCollection<?> keys) {
        super(cacheName, commandInvocationId, topologyId, flags, sequence, segmentId, function, params, keyDataConversion, valueDataConversion);
        this.writeOnly = writeOnly;
        this.keys = MarshallableCollection.unwrap(keys);
    }

    @ProtoField(value=11)
    boolean isWriteOnly() {
        return this.writeOnly;
    }

    @ProtoField(value=12)
    MarshallableCollection<?> getKeys() {
        return MarshallableCollection.create(this.keys);
    }

    @Override
    WriteCommand createWriteCommand() {
        AbstractWriteManyCommand cmd = this.writeOnly ? new WriteOnlyManyCommand(this.cacheName, this.keys, (Consumer)this.function, this.params, this.getCommandInvocationId(), this.keyDataConversion, this.valueDataConversion) : new ReadWriteManyCommand(this.cacheName, this.keys, (Function)this.function, this.params, this.getCommandInvocationId(), this.keyDataConversion, this.valueDataConversion);
        cmd.setForwarded(true);
        return cmd;
    }

    @Override
    public NodeVersion supportedSince() {
        return NodeVersion.SIXTEEN;
    }
}

