/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.topology;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.topology.AbstractCacheControlCommand;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.marshall.protostream.impl.WrappedMessages;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.NodeVersion;
import org.infinispan.topology.CacheTopology;

@ProtoTypeId(value=1235)
public class TopologyUpdateCommand
extends AbstractCacheControlCommand {
    @ProtoField(value=1)
    final String cacheName;
    @ProtoField(value=2)
    final WrappedMessage currentCH;
    @ProtoField(value=3)
    final WrappedMessage pendingCH;
    @ProtoField(value=4)
    final CacheTopology.Phase phase;
    @ProtoField(value=5)
    final List<Address> actualMembers;
    @ProtoField(value=6)
    final List<UUID> persistentUUIDs;
    @ProtoField(value=7)
    final AvailabilityMode availabilityMode;
    @ProtoField(value=8)
    final int rebalanceId;
    @ProtoField(value=9)
    final int topologyId;
    @ProtoField(value=10)
    final int viewId;

    @ProtoFactory
    TopologyUpdateCommand(String cacheName, WrappedMessage currentCH, WrappedMessage pendingCH, CacheTopology.Phase phase, List<Address> actualMembers, List<UUID> persistentUUIDs, AvailabilityMode availabilityMode, int rebalanceId, int topologyId, int viewId) {
        this.cacheName = cacheName;
        this.currentCH = currentCH;
        this.pendingCH = pendingCH;
        this.phase = phase;
        this.actualMembers = actualMembers;
        this.persistentUUIDs = persistentUUIDs;
        this.availabilityMode = availabilityMode;
        this.rebalanceId = rebalanceId;
        this.topologyId = topologyId;
        this.viewId = viewId;
    }

    public TopologyUpdateCommand(String cacheName, Address origin, CacheTopology cacheTopology, AvailabilityMode availabilityMode, int viewId) {
        super(origin);
        this.cacheName = cacheName;
        this.topologyId = cacheTopology.getTopologyId();
        this.rebalanceId = cacheTopology.getRebalanceId();
        this.currentCH = new WrappedMessage((Object)cacheTopology.getCurrentCH());
        this.pendingCH = new WrappedMessage((Object)cacheTopology.getPendingCH());
        this.phase = cacheTopology.getPhase();
        this.availabilityMode = availabilityMode;
        this.actualMembers = cacheTopology.getActualMembers();
        this.persistentUUIDs = cacheTopology.getMembersPersistentUUIDs();
        this.viewId = viewId;
    }

    @Override
    public CompletionStage<?> invokeAsync(GlobalComponentRegistry gcr) throws Throwable {
        CacheTopology topology = new CacheTopology(this.topologyId, this.rebalanceId, this.getCurrentCH(), this.getPendingCH(), this.phase, this.actualMembers, this.persistentUUIDs);
        return gcr.getLocalTopologyManager().handleTopologyUpdate(this.cacheName, topology, this.availabilityMode, this.viewId, this.origin);
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public ConsistentHash getCurrentCH() {
        return (ConsistentHash)WrappedMessages.unwrap(this.currentCH);
    }

    public ConsistentHash getPendingCH() {
        return (ConsistentHash)WrappedMessages.unwrap(this.pendingCH);
    }

    public CacheTopology.Phase getPhase() {
        return this.phase;
    }

    public AvailabilityMode getAvailabilityMode() {
        return this.availabilityMode;
    }

    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public NodeVersion supportedSince() {
        return NodeVersion.SIXTEEN;
    }

    public String toString() {
        return "TopologyUpdateCommand{cacheName='" + this.cacheName + "', origin=" + String.valueOf(this.origin) + ", currentCH=" + String.valueOf(this.getCurrentCH()) + ", pendingCH=" + String.valueOf(this.getPendingCH()) + ", phase=" + String.valueOf((Object)this.phase) + ", actualMembers=" + String.valueOf(this.actualMembers) + ", persistentUUIDs=" + String.valueOf(this.persistentUUIDs) + ", availabilityMode=" + String.valueOf((Object)this.availabilityMode) + ", rebalanceId=" + this.rebalanceId + ", topologyId=" + this.topologyId + ", viewId=" + this.viewId + "}";
    }
}

