/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands;

import java.util.Objects;
import java.util.UUID;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.Address;

@ProtoTypeId(value=52)
public final class RequestUUID {
    private static final long LOCAL_BITS = 1L;
    private static final UUID LOCAL_UUID = new UUID(1L, 1L);
    private static final long NO_REQUEST_BITS = 0L;
    private static final UUID NO_REQUEST_UUID = new UUID(0L, 0L);
    public static RequestUUID NO_REQUEST = new RequestUUID(NO_REQUEST_UUID, 0L);
    private final UUID nodeUUID;
    private final long requestId;

    private RequestUUID(UUID nodeUUID, long requestId) {
        this.nodeUUID = Objects.requireNonNull(nodeUUID);
        this.requestId = requestId;
    }

    public static RequestUUID of(Address address, long requestId) {
        return new RequestUUID(address.getNodeUUID(), requestId);
    }

    public static RequestUUID localOf(long requestId) {
        return new RequestUUID(LOCAL_UUID, requestId);
    }

    @ProtoFactory
    static RequestUUID protoFactory(long mostSignificantBits, long leastSignificantBits, long requestId) {
        if (mostSignificantBits == 0L && leastSignificantBits == 0L && requestId == 0L) {
            return NO_REQUEST;
        }
        if (mostSignificantBits == 1L && leastSignificantBits == 1L) {
            return RequestUUID.localOf(requestId);
        }
        return new RequestUUID(new UUID(mostSignificantBits, leastSignificantBits), requestId);
    }

    @ProtoField(value=1, defaultValue="0")
    long getMostSignificantBits() {
        return this.nodeUUID.getMostSignificantBits();
    }

    @ProtoField(value=2, defaultValue="0")
    long getLeastSignificantBits() {
        return this.nodeUUID.getLeastSignificantBits();
    }

    @ProtoField(value=3)
    public long getRequestId() {
        return this.requestId;
    }

    public Address toAddress() {
        return this.nodeUUID == LOCAL_UUID ? null : Address.fromNodeUUID(this.nodeUUID);
    }

    public String toIdString() {
        return this.prettyPrintAddress() + ":" + this.requestId;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        RequestUUID that = (RequestUUID)obj;
        return this.nodeUUID.equals(that.nodeUUID) && this.requestId == that.requestId;
    }

    public int hashCode() {
        return Objects.hash(this.nodeUUID, this.requestId);
    }

    public String toString() {
        return "RequestUUID[nodeUUID=" + this.prettyPrintAddress() + ", requestId=" + this.requestId + "]";
    }

    private String prettyPrintAddress() {
        if (this.nodeUUID == LOCAL_UUID) {
            return "local";
        }
        if (this.nodeUUID == NO_REQUEST_UUID) {
            return "no-request";
        }
        return Address.nodeUUIDToString(this.nodeUUID);
    }
}

