/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.remoting.transport.Address;
import org.jgroups.util.ExtendedUUID;
import org.jgroups.util.NameCache;

public class AddressCache {
    private static final Map<ExtendedUUID, Address> addressCache = new ConcurrentHashMap<ExtendedUUID, Address>();

    public static Address fromExtendedUUID(ExtendedUUID addr) {
        Address existing = addressCache.get(addr);
        return existing == null ? addressCache.computeIfAbsent(addr, Address::fromExtendedUUID) : existing;
    }

    public static Address getIfPresent(long mostSignificantBits, long leastSignificantBits) {
        return addressCache.get(new ExtendedUUID(mostSignificantBits, leastSignificantBits));
    }

    static void pruneAddressCache() {
        addressCache.keySet().removeIf(addr -> NameCache.get((org.jgroups.Address)addr) == null);
    }
}

