/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.protostream.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ByteBufferImpl;
import org.infinispan.commons.marshall.BufferSizePredictor;
import org.infinispan.commons.marshall.MarshallableTypeHints;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.MarshallingException;
import org.infinispan.commons.marshall.StreamAwareMarshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.marshall.protostream.impl.AbstractMarshallableWrapper;
import org.infinispan.marshall.protostream.impl.MarshallableUserObject;
import org.infinispan.marshall.protostream.impl.SerializationContextRegistry;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.RandomAccessOutputStream;
import org.infinispan.protostream.impl.RandomAccessOutputStreamImpl;
import org.infinispan.util.logging.Log;

@Scope(value=Scopes.GLOBAL)
public abstract class AbstractInternalProtoStreamMarshaller
implements Marshaller,
StreamAwareMarshaller {
    protected final MarshallableTypeHints marshallableTypeHints = new MarshallableTypeHints();
    @Inject
    protected SerializationContextRegistry ctxRegistry;
    @Inject
    @ComponentName(value="org.infinispan.marshaller.user")
    ComponentRef<Marshaller> userMarshallerRef;
    protected Marshaller userMarshaller;
    protected boolean skipUserMarshaller;
    protected Log log;

    public abstract ImmutableSerializationContext getSerializationContext();

    protected AbstractInternalProtoStreamMarshaller(Log log) {
        this.log = log;
    }

    @Start
    public void start() {
        this.userMarshaller = this.userMarshallerRef.running();
    }

    public Marshaller getUserMarshaller() {
        return this.userMarshaller;
    }

    protected RandomAccessOutputStream objectToOutputStream(Object obj, int estimatedSize) {
        try {
            RandomAccessOutputStreamImpl os = new RandomAccessOutputStreamImpl(estimatedSize);
            ProtobufUtil.toWrappedStream((ImmutableSerializationContext)this.getSerializationContext(), (RandomAccessOutputStream)os, (Object)obj);
            return os;
        }
        catch (Throwable t) {
            this.log.cannotMarshall(obj.getClass(), t);
            if (t instanceof MarshallingException) {
                throw (MarshallingException)t;
            }
            throw new MarshallingException(t.getMessage(), t.getCause());
        }
    }

    public ByteBuffer objectToBuffer(Object obj) {
        ByteBufferImpl byteBufferImpl;
        block10: {
            if (obj == null) {
                return ByteBufferImpl.EMPTY_INSTANCE;
            }
            BufferSizePredictor sizePredictor = this.marshallableTypeHints.getBufferSizePredictor((Object)obj);
            int estimatedSize = sizePredictor.nextSize((Object)obj);
            if (this.requiresWrapping(obj)) {
                obj = new MarshallableUserObject<Object>(obj);
                estimatedSize = AbstractMarshallableWrapper.size(estimatedSize);
            }
            RandomAccessOutputStream os = this.objectToOutputStream(obj, estimatedSize);
            try {
                int length = os.getPosition();
                ByteBufferImpl buf = ByteBufferImpl.create((java.nio.ByteBuffer)os.getByteBuffer());
                sizePredictor.recordSize(length);
                byteBufferImpl = buf;
                if (os == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new MarshallingException((Throwable)e);
                }
            }
            os.close();
        }
        return byteBufferImpl;
    }

    public byte[] objectToByteBuffer(Object obj, int estimatedSize) {
        byte[] byArray;
        block10: {
            if (obj == null) {
                return Util.EMPTY_BYTE_ARRAY;
            }
            if (this.requiresWrapping(obj)) {
                obj = new MarshallableUserObject<Object>(obj);
                estimatedSize = AbstractMarshallableWrapper.size(estimatedSize);
            }
            BufferSizePredictor sizePredictor = this.marshallableTypeHints.getBufferSizePredictor((Object)obj);
            RandomAccessOutputStream os = this.objectToOutputStream(obj, estimatedSize);
            try {
                byte[] bytes = os.toByteArray();
                sizePredictor.recordSize(bytes.length);
                byArray = bytes;
                if (os == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new MarshallingException((Throwable)e);
                }
            }
            os.close();
        }
        return byArray;
    }

    public byte[] objectToByteBuffer(Object obj) {
        return this.objectToBuffer(obj).trim();
    }

    public Object objectFromByteBuffer(byte[] buf) throws IOException {
        return this.objectFromByteBuffer(buf, 0, buf.length);
    }

    public Object objectFromByteBuffer(byte[] buf, int offset, int length) throws IOException {
        return this.unwrapAndInit(ProtobufUtil.fromWrappedByteArray((ImmutableSerializationContext)this.getSerializationContext(), (byte[])buf, (int)offset, (int)length));
    }

    public Object objectFromByteBuffer(java.nio.ByteBuffer buf) throws IOException {
        return this.unwrapAndInit(ProtobufUtil.fromWrappedByteBuffer((ImmutableSerializationContext)this.getSerializationContext(), (java.nio.ByteBuffer)buf));
    }

    public BufferSizePredictor getBufferSizePredictor(Object o) {
        return this.marshallableTypeHints.getBufferSizePredictor(o.getClass());
    }

    public void writeObject(Object o, OutputStream out) throws IOException {
        if (this.requiresWrapping(o)) {
            o = new MarshallableUserObject<Object>(o);
        }
        ProtobufUtil.toWrappedStream((ImmutableSerializationContext)this.getSerializationContext(), (OutputStream)out, o);
    }

    public Object readObject(InputStream in) throws ClassNotFoundException, IOException {
        return this.unwrapAndInit(ProtobufUtil.fromWrappedStream((ImmutableSerializationContext)this.getSerializationContext(), (InputStream)in));
    }

    protected Object unwrapAndInit(Object o) {
        if (o instanceof MarshallableUserObject) {
            return ((MarshallableUserObject)o).get();
        }
        return o;
    }

    public boolean isMarshallable(Object o) {
        return this.isMarshallableWithProtoStream(o) || this.isUserMarshallable(o);
    }

    public int sizeEstimate(Object o) {
        if (this.skipUserMarshaller) {
            return this.marshallableTypeHints.getBufferSizePredictor(o.getClass()).nextSize(o);
        }
        int userBytesEstimate = this.userMarshaller.getBufferSizePredictor(o.getClass()).nextSize(o);
        return MarshallableUserObject.size(userBytesEstimate);
    }

    public MediaType mediaType() {
        return MediaType.APPLICATION_PROTOSTREAM;
    }

    private boolean requiresWrapping(Object o) {
        return !this.skipUserMarshaller && !this.isMarshallableWithProtoStream(o);
    }

    protected boolean isMarshallableWithProtoStream(Object o) {
        return this.getSerializationContext().canMarshall(o.getClass());
    }

    private boolean isUserMarshallable(Object o) {
        try {
            return this.userMarshaller.isMarshallable(o);
        }
        catch (Exception ignore) {
            return false;
        }
    }
}

