/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.offheap;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.commons.marshall.WrappedBytes;
import org.infinispan.commons.spi.OffHeapMemory;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.container.offheap.Bits;
import org.infinispan.container.offheap.OffHeapEntryFactory;
import org.infinispan.container.offheap.OffHeapMemoryAllocator;
import org.infinispan.container.offheap.UnpooledOffHeapMemoryAllocator;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;

@Scope(value=Scopes.NAMED_CACHE)
public class OffHeapEntryFactoryImpl
implements OffHeapEntryFactory {
    private static final OffHeapMemory MEMORY = org.infinispan.commons.jdkspecific.OffHeapMemory.getInstance();
    @Inject
    @ComponentName(value="org.infinispan.marshaller.internal")
    Marshaller marshaller;
    @Inject
    OffHeapMemoryAllocator allocator;
    @Inject
    TimeService timeService;
    @Inject
    InternalEntryFactory internalEntryFactory;
    @Inject
    Configuration configuration;
    private boolean evictionEnabled;
    private static final byte CUSTOM = 1;
    private static final byte HAS_VERSION = 2;
    private static final byte IMMORTAL = 4;
    private static final byte MORTAL = 8;
    private static final byte TRANSIENT = 16;
    private static final byte TRANSIENT_MORTAL = 32;
    private static final byte EXPIRATION_TYPES = 60;
    private static final byte HAS_PRIVATE_METADATA = 64;
    static final int HEADER_LENGTH = 13;

    @Start
    public void start() {
        this.evictionEnabled = this.configuration.memory().isEvictionEnabled();
    }

    @Override
    public long create(WrappedBytes key, int hashCode, InternalCacheEntry<WrappedBytes, WrappedBytes> ice) {
        int internalMetadataSize;
        byte[] internalMetadataBytes;
        int valueSize;
        byte[] metadataBytes;
        byte type;
        boolean shouldWriteMetadataSize = false;
        Metadata metadata = ice.getMetadata();
        if (metadata instanceof EmbeddedMetadata) {
            byte[] versionBytes;
            EntryVersion version = metadata.version();
            if (version != null) {
                type = 2;
                shouldWriteMetadataSize = true;
                try {
                    versionBytes = this.marshaller.objectToByteBuffer((Object)version);
                }
                catch (IOException | InterruptedException e) {
                    throw new CacheException((Throwable)e);
                }
            } else {
                type = 0;
                versionBytes = Util.EMPTY_BYTE_ARRAY;
            }
            long lifespan = metadata.lifespan();
            long maxIdle = metadata.maxIdle();
            if (lifespan < 0L && maxIdle < 0L) {
                type = (byte)(type | 4);
                metadataBytes = versionBytes;
            } else if (lifespan > -1L && maxIdle < 0L) {
                type = (byte)(type | 8);
                metadataBytes = new byte[16 + versionBytes.length];
                Bits.putLong(metadataBytes, 0, lifespan);
                Bits.putLong(metadataBytes, 8, ice.getCreated());
                System.arraycopy(versionBytes, 0, metadataBytes, 16, versionBytes.length);
            } else if (lifespan < 0L) {
                type = (byte)(type | 0x10);
                metadataBytes = new byte[16 + versionBytes.length];
                Bits.putLong(metadataBytes, 0, maxIdle);
                Bits.putLong(metadataBytes, 8, ice.getLastUsed());
                System.arraycopy(versionBytes, 0, metadataBytes, 16, versionBytes.length);
            } else {
                type = (byte)(type | 0x20);
                metadataBytes = new byte[32 + versionBytes.length];
                Bits.putLong(metadataBytes, 0, lifespan);
                Bits.putLong(metadataBytes, 8, maxIdle);
                Bits.putLong(metadataBytes, 16, ice.getCreated());
                Bits.putLong(metadataBytes, 24, ice.getLastUsed());
                System.arraycopy(versionBytes, 0, metadataBytes, 32, versionBytes.length);
            }
        } else {
            type = 1;
            shouldWriteMetadataSize = true;
            metadataBytes = this.marshall(metadata);
        }
        int keySize = key.getLength();
        int metadataSize = metadataBytes.length;
        WrappedBytes value = (WrappedBytes)ice.getValue();
        int n = valueSize = value != null ? value.getLength() : 0;
        if (OffHeapEntryFactoryImpl.shouldWriteInternalMetadata(ice.getInternalMetadata())) {
            internalMetadataBytes = this.marshall(ice.getInternalMetadata());
            internalMetadataSize = internalMetadataBytes.length;
            type = (byte)(type | 0x40);
        } else {
            internalMetadataBytes = null;
            internalMetadataSize = 0;
        }
        int offset = this.evictionEnabled ? 16 : 0;
        long totalSize = UnpooledOffHeapMemoryAllocator.offHeapEntrySize(this.evictionEnabled, shouldWriteMetadataSize, keySize, valueSize, metadataSize, internalMetadataSize);
        long memoryAddress = this.allocator.allocate(totalSize);
        MEMORY.putLong(memoryAddress, (long)offset, 0L);
        MEMORY.putByte(memoryAddress, (long)(offset += 8), type);
        MEMORY.putInt(memoryAddress, (long)(++offset), hashCode);
        MEMORY.putInt(memoryAddress, (long)(offset += 4), key.getLength());
        offset += 4;
        if (shouldWriteMetadataSize) {
            MEMORY.putInt(memoryAddress, (long)offset, metadataBytes.length);
            offset += 4;
        }
        MEMORY.putInt(memoryAddress, (long)offset, valueSize);
        offset += 4;
        if (internalMetadataSize > 0) {
            MEMORY.putInt(memoryAddress, (long)offset, internalMetadataSize);
            offset += 4;
        }
        MEMORY.putBytes(key.getBytes(), (long)key.backArrayOffset(), memoryAddress, (long)offset, (long)keySize);
        MEMORY.putBytes(metadataBytes, 0L, memoryAddress, (long)(offset += keySize), (long)metadataSize);
        offset += metadataSize;
        if (valueSize > 0) {
            MEMORY.putBytes(value.getBytes(), (long)value.backArrayOffset(), memoryAddress, (long)offset, (long)valueSize);
            offset += valueSize;
        }
        if (internalMetadataSize > 0) {
            MEMORY.putBytes(internalMetadataBytes, 0L, memoryAddress, (long)offset, (long)internalMetadataSize);
            offset += internalMetadataSize;
        }
        assert ((long)offset == totalSize);
        return memoryAddress;
    }

    @Override
    public long getSize(long entryAddress, boolean includeAllocationOverhead) {
        int internalMetadataLength;
        int metadataLength;
        int headerOffset = this.evictionEnabled ? 24 : 8;
        byte type = MEMORY.getByte(entryAddress, (long)headerOffset);
        ++headerOffset;
        int keyLength = MEMORY.getInt(entryAddress, (long)(headerOffset += 4));
        headerOffset += 4;
        if ((type & 3) != 0) {
            metadataLength = MEMORY.getInt(entryAddress, (long)headerOffset);
            headerOffset += 4;
        } else {
            switch (type & 0x3C) {
                case 4: {
                    metadataLength = 0;
                    break;
                }
                case 8: 
                case 16: {
                    metadataLength = 16;
                    break;
                }
                case 32: {
                    metadataLength = 32;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported type: " + type);
                }
            }
        }
        int valueLength = MEMORY.getInt(entryAddress, (long)headerOffset);
        headerOffset += 4;
        if (OffHeapEntryFactoryImpl.requiresInternalMetadataSize(type)) {
            internalMetadataLength = MEMORY.getInt(entryAddress, (long)headerOffset);
            headerOffset += 4;
        } else {
            internalMetadataLength = 0;
        }
        int size = headerOffset + keyLength + metadataLength + valueLength + internalMetadataLength;
        return includeAllocationOverhead ? UnpooledOffHeapMemoryAllocator.estimateSizeOverhead(size) : (long)size;
    }

    @Override
    public long getNext(long entryAddress) {
        return MEMORY.getLong(entryAddress, this.evictionEnabled ? 16L : 0L);
    }

    @Override
    public void setNext(long entryAddress, long value) {
        MEMORY.putLong(entryAddress, this.evictionEnabled ? 16L : 0L, value);
    }

    @Override
    public int getHashCode(long entryAddress) {
        int headerOffset = this.evictionEnabled ? 25 : 9;
        return MEMORY.getInt(entryAddress, (long)headerOffset);
    }

    @Override
    public byte[] getKey(long address) {
        int offset = this.evictionEnabled ? 24 : 8;
        byte metadataType = MEMORY.getByte(address, (long)offset);
        ++offset;
        byte[] keyBytes = new byte[MEMORY.getInt(address, (long)(offset += 4))];
        offset += 4;
        if ((metadataType & 3) != 0) {
            offset += 4;
        }
        offset += 4;
        if (OffHeapEntryFactoryImpl.requiresInternalMetadataSize(metadataType)) {
            offset += 4;
        }
        MEMORY.getBytes(address, (long)offset, keyBytes, 0L, (long)keyBytes.length);
        return keyBytes;
    }

    @Override
    public InternalCacheEntry<WrappedBytes, WrappedBytes> fromMemory(long address) {
        long lastUsed;
        long created;
        long maxIdle;
        long lifespan;
        WrappedByteArray valueWrappedBytes;
        int internalMetadataSize;
        byte[] metadataBytes;
        int offset = this.evictionEnabled ? 24 : 8;
        byte metadataType = MEMORY.getByte(address, (long)offset);
        int hashCode = MEMORY.getInt(address, (long)(++offset));
        byte[] keyBytes = new byte[MEMORY.getInt(address, (long)(offset += 4))];
        offset += 4;
        switch (metadataType & 0xFFFFFFBF) {
            case 4: {
                metadataBytes = Util.EMPTY_BYTE_ARRAY;
                break;
            }
            case 8: 
            case 16: {
                metadataBytes = new byte[16];
                break;
            }
            case 32: {
                metadataBytes = new byte[32];
                break;
            }
            default: {
                metadataBytes = new byte[MEMORY.getInt(address, (long)offset)];
                offset += 4;
            }
        }
        int valueSize = MEMORY.getInt(address, (long)offset);
        offset += 4;
        if (OffHeapEntryFactoryImpl.requiresInternalMetadataSize(metadataType)) {
            internalMetadataSize = MEMORY.getInt(address, (long)offset);
            offset += 4;
        } else {
            internalMetadataSize = 0;
        }
        MEMORY.getBytes(address, (long)offset, keyBytes, 0L, (long)keyBytes.length);
        MEMORY.getBytes(address, (long)(offset += keyBytes.length), metadataBytes, 0L, (long)metadataBytes.length);
        offset += metadataBytes.length;
        if (valueSize > 0) {
            byte[] valueBytes = new byte[valueSize];
            MEMORY.getBytes(address, (long)offset, valueBytes, 0L, (long)valueBytes.length);
            offset += valueBytes.length;
            valueWrappedBytes = new WrappedByteArray(valueBytes);
        } else {
            valueWrappedBytes = null;
        }
        PrivateMetadata internalMetadata = PrivateMetadata.empty();
        if (internalMetadataSize > 0) {
            byte[] internalMetadataBytes = new byte[internalMetadataSize];
            MEMORY.getBytes(address, (long)offset, internalMetadataBytes, 0L, (long)internalMetadataSize);
            offset += internalMetadataSize;
            internalMetadata = (PrivateMetadata)this.unmarshall(internalMetadataBytes);
        }
        if ((metadataType & 1) == 1) {
            Metadata metadata = (Metadata)this.unmarshall(metadataBytes);
            InternalCacheEntry<WrappedByteArray, WrappedByteArray> ice = this.internalEntryFactory.create(new WrappedByteArray(keyBytes, hashCode), valueWrappedBytes, metadata);
            ice.setInternalMetadata(internalMetadata);
            return ice;
        }
        offset = 0;
        boolean hasVersion = (metadataType & 2) == 2;
        switch (metadataType & 0x3C) {
            case 4: {
                lifespan = -1L;
                maxIdle = -1L;
                created = -1L;
                lastUsed = -1L;
                break;
            }
            case 8: {
                maxIdle = -1L;
                lifespan = Bits.getLong(metadataBytes, offset);
                created = Bits.getLong(metadataBytes, offset += 8);
                offset += 8;
                lastUsed = -1L;
                break;
            }
            case 16: {
                lifespan = -1L;
                maxIdle = Bits.getLong(metadataBytes, offset);
                created = -1L;
                lastUsed = Bits.getLong(metadataBytes, offset += 8);
                offset += 8;
                break;
            }
            case 32: {
                lifespan = Bits.getLong(metadataBytes, offset);
                maxIdle = Bits.getLong(metadataBytes, offset += 8);
                created = Bits.getLong(metadataBytes, offset += 8);
                lastUsed = Bits.getLong(metadataBytes, offset += 8);
                offset += 8;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type: " + metadataType);
            }
        }
        if (hasVersion) {
            try {
                EntryVersion version = (EntryVersion)this.marshaller.objectFromByteBuffer(metadataBytes, offset, metadataBytes.length - offset);
                InternalCacheEntry<WrappedByteArray, WrappedByteArray> ice = this.internalEntryFactory.create(new WrappedByteArray(keyBytes, hashCode), valueWrappedBytes, version, created, lifespan, lastUsed, maxIdle);
                ice.setInternalMetadata(internalMetadata);
                return ice;
            }
            catch (IOException | ClassNotFoundException e) {
                throw new CacheException((Throwable)e);
            }
        }
        InternalCacheEntry<WrappedByteArray, WrappedByteArray> ice = this.internalEntryFactory.create(new WrappedByteArray(keyBytes, hashCode), valueWrappedBytes, (Metadata)null, created, lifespan, lastUsed, maxIdle);
        ice.setInternalMetadata(internalMetadata);
        return ice;
    }

    @Override
    public boolean equalsKey(long address, WrappedBytes wrappedBytes, int hashCode) {
        int headerOffset = this.evictionEnabled ? 24 : 8;
        byte type = MEMORY.getByte(address, (long)headerOffset);
        if (hashCode != MEMORY.getInt(address, (long)(++headerOffset))) {
            return false;
        }
        int keyLength = MEMORY.getInt(address, (long)(headerOffset += 4));
        if (keyLength != wrappedBytes.getLength()) {
            return false;
        }
        headerOffset += 4;
        if (OffHeapEntryFactoryImpl.requiresMetadataSize(type)) {
            headerOffset += 4;
        }
        headerOffset += 4;
        if (OffHeapEntryFactoryImpl.requiresInternalMetadataSize(type)) {
            headerOffset += 4;
        }
        for (int i = 0; i < keyLength; ++i) {
            byte b = MEMORY.getByte(address, (long)(headerOffset + i));
            if (b == wrappedBytes.getByte(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isExpired(long address) {
        int offset = this.evictionEnabled ? 24 : 8;
        byte metadataType = MEMORY.getByte(address, (long)offset);
        if ((metadataType & 4) != 0) {
            return false;
        }
        ++offset;
        int keyLength = MEMORY.getInt(address, (long)(offset += 4));
        offset += 4;
        long now = this.timeService.wallClockTime();
        if ((metadataType & 1) == 1) {
            return false;
        }
        offset += 4 + keyLength;
        if (OffHeapEntryFactoryImpl.requiresInternalMetadataSize(metadataType)) {
            offset += 4;
        }
        if ((metadataType & 2) != 0) {
            offset += 4;
        }
        switch (metadataType & 0x3C) {
            case 8: {
                byte[] metadataBytes = new byte[16];
                MEMORY.getBytes(address, (long)offset, metadataBytes, 0L, (long)metadataBytes.length);
                return ExpiryHelper.isExpiredMortal(Bits.getLong(metadataBytes, 0), Bits.getLong(metadataBytes, 8), now);
            }
            case 16: {
                byte[] metadataBytes = new byte[16];
                MEMORY.getBytes(address, (long)offset, metadataBytes, 0L, (long)metadataBytes.length);
                return ExpiryHelper.isExpiredTransient(Bits.getLong(metadataBytes, 0), Bits.getLong(metadataBytes, 8), now);
            }
            case 32: {
                byte[] metadataBytes = new byte[32];
                MEMORY.getBytes(address, (long)offset, metadataBytes, 0L, (long)metadataBytes.length);
                long lifespan = Bits.getLong(metadataBytes, 0);
                long maxIdle = Bits.getLong(metadataBytes, 8);
                long created = Bits.getLong(metadataBytes, 16);
                long lastUsed = Bits.getLong(metadataBytes, 24);
                return ExpiryHelper.isExpiredTransientMortal(maxIdle, lastUsed, lifespan, created, now);
            }
        }
        return false;
    }

    private static boolean requiresMetadataSize(byte type) {
        return (type & 3) != 0;
    }

    private static boolean requiresInternalMetadataSize(byte type) {
        return (type & 0x40) == 64;
    }

    @Override
    public long calculateSize(WrappedBytes key, WrappedBytes value, Metadata metadata, PrivateMetadata internalMetadata) {
        long totalSize = this.evictionEnabled ? 24L : 8L;
        totalSize += 13L;
        totalSize += (long)(key.getLength() + value.getLength());
        long metadataSize = 0L;
        if (metadata instanceof EmbeddedMetadata) {
            EntryVersion version = metadata.version();
            if (version != null) {
                metadataSize = this.marshall(version).length;
                metadataSize += 4L;
            }
            if (metadata.maxIdle() >= 0L) {
                metadataSize += 16L;
            }
            if (metadata.lifespan() >= 0L) {
                metadataSize += 16L;
            }
        } else {
            metadataSize += 4L;
            metadataSize += (long)this.marshall(metadata).length;
        }
        long internalMetadataSize = OffHeapEntryFactoryImpl.shouldWriteInternalMetadata(internalMetadata) ? (long)(this.marshall(internalMetadata).length + 4) : 0L;
        return UnpooledOffHeapMemoryAllocator.estimateSizeOverhead(totalSize + metadataSize + internalMetadataSize);
    }

    @Override
    public long updateMaxIdle(long address, long currentTimeMillis) {
        int internalMetadataSize;
        long offset = this.evictionEnabled ? 24L : 8L;
        byte metadataType = MEMORY.getByte(address, offset);
        if ((metadataType & 0xC) != 0) {
            return 0L;
        }
        int keySize = MEMORY.getInt(address, offset += 5L);
        offset += 4L;
        boolean hasVersion = (metadataType & 2) != 0;
        boolean hasInternalMetadata = OffHeapEntryFactoryImpl.requiresInternalMetadataSize(metadataType);
        if ((metadataType & 0x10) != 0) {
            this.storeLongLittleEndian(address, (offset += (long)((hasVersion ? 4 : 0) + (hasInternalMetadata ? 4 : 0) + 4 + keySize)) + 8L, currentTimeMillis);
            return 0L;
        }
        if ((metadataType & 0x20) != 0) {
            this.storeLongLittleEndian(address, (offset += (long)((hasVersion ? 4 : 0) + (hasInternalMetadata ? 4 : 0) + 4 + keySize)) + 24L, currentTimeMillis);
            return 0L;
        }
        byte[] metadataBytes = new byte[MEMORY.getInt(address, offset)];
        int metadataSize = metadataBytes.length;
        int valueSize = MEMORY.getInt(address, offset += 4L);
        offset += 4L;
        if (hasInternalMetadata) {
            internalMetadataSize = MEMORY.getInt(address, offset);
            offset += 4L;
        } else {
            internalMetadataSize = 0;
        }
        MEMORY.getBytes(address, offset += (long)keySize, metadataBytes, 0L, (long)metadataSize);
        Metadata metadata = (Metadata)this.unmarshall(metadataBytes);
        Metadata newMetadata = metadata.builder().maxIdle(currentTimeMillis, TimeUnit.MILLISECONDS).build();
        byte[] newMetadataBytes = this.marshall(newMetadata, metadataSize);
        int newMetadataSize = newMetadataBytes.length;
        if (newMetadataSize != metadataSize) {
            long newPointer = MEMORY.allocate((long)newMetadataSize + offset + (long)valueSize + (long)internalMetadataSize);
            MEMORY.copy(address, 0L, newPointer, 0L, offset);
            MEMORY.putBytes(newMetadataBytes, 0L, newPointer, offset, (long)newMetadataSize);
            MEMORY.copy(address, offset + (long)metadataSize, newPointer, offset + (long)newMetadataSize, (long)valueSize);
            if (internalMetadataSize > 0) {
                MEMORY.copy(address, offset + (long)metadataSize + (long)valueSize, newPointer, offset + (long)newMetadataSize + (long)valueSize, (long)internalMetadataSize);
            }
            return newPointer;
        }
        MEMORY.putBytes(metadataBytes, 0L, address, offset, (long)metadataSize);
        return 0L;
    }

    private void storeLongLittleEndian(long destAddres, long offset, long value) {
        MEMORY.putByte(destAddres, offset, (byte)(value >> 56));
        MEMORY.putByte(destAddres, offset + 1L, (byte)(value >> 48));
        MEMORY.putByte(destAddres, offset + 2L, (byte)(value >> 40));
        MEMORY.putByte(destAddres, offset + 3L, (byte)(value >> 32));
        MEMORY.putByte(destAddres, offset + 4L, (byte)(value >> 24));
        MEMORY.putByte(destAddres, offset + 5L, (byte)(value >> 16));
        MEMORY.putByte(destAddres, offset + 6L, (byte)(value >> 8));
        MEMORY.putByte(destAddres, offset + 7L, (byte)value);
    }

    private <T> byte[] marshall(T obj) {
        try {
            return this.marshaller.objectToByteBuffer(obj);
        }
        catch (IOException e) {
            throw new CacheException((Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CacheException((Throwable)e);
        }
    }

    private <T> byte[] marshall(T obj, int estimatedSize) {
        try {
            return this.marshaller.objectToByteBuffer(obj, estimatedSize);
        }
        catch (IOException e) {
            throw new CacheException((Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CacheException((Throwable)e);
        }
    }

    private <T> T unmarshall(byte[] bytes) {
        try {
            return (T)this.marshaller.objectFromByteBuffer(bytes);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new CacheException((Throwable)e);
        }
    }

    private static boolean shouldWriteInternalMetadata(PrivateMetadata metadata) {
        return metadata != null && !metadata.isEmpty();
    }
}

