/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.irac;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.irac.BaseIracCommand;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.container.versioning.irac.IracTombstoneInfo;
import org.infinispan.container.versioning.irac.IracTombstoneManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.NodeVersion;
import org.infinispan.util.ByteString;

@ProtoTypeId(value=1106)
public class IracTombstoneCleanupCommand
extends BaseIracCommand {
    @ProtoField(value=2)
    final Collection<IracTombstoneInfo> tombstonesToRemove;

    @ProtoFactory
    IracTombstoneCleanupCommand(ByteString cacheName, ArrayList<IracTombstoneInfo> tombstonesToRemove) {
        super(cacheName);
        this.tombstonesToRemove = tombstonesToRemove;
    }

    public IracTombstoneCleanupCommand(ByteString cacheName, int maxCapacity) {
        super(cacheName);
        this.tombstonesToRemove = new HashSet<IracTombstoneInfo>(maxCapacity);
    }

    public CompletionStage<Boolean> invokeAsync(ComponentRegistry registry) {
        IracTombstoneManager tombstoneManager = registry.getIracTombstoneManager().running();
        this.tombstonesToRemove.forEach(tombstoneManager::removeTombstone);
        return CompletableFutures.completedNull();
    }

    @Override
    public NodeVersion supportedSince() {
        return NodeVersion.SIXTEEN;
    }

    public String toString() {
        return "IracTombstoneCleanupCommand{cacheName=" + String.valueOf(this.cacheName) + ", tombstone=" + String.valueOf(this.tombstonesToRemove) + "}";
    }

    public void add(IracTombstoneInfo tombstone) {
        this.tombstonesToRemove.add(tombstone);
    }

    public int size() {
        return this.tombstonesToRemove.size();
    }

    public boolean isEmpty() {
        return this.tombstonesToRemove.isEmpty();
    }

    public Collection<IracTombstoneInfo> getTombstonesToRemove() {
        return this.tombstonesToRemove;
    }
}

