/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional.functions;

import java.io.Serializable;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.infinispan.cache.impl.BiFunctionMapper;
import org.infinispan.commands.functional.functions.InjectableComponent;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.metadata.Metadata;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.util.UserRaisedFunctionalException;

@ProtoTypeId(value=1120)
public class MergeFunction<K, V>
implements Function<EntryView.ReadWriteEntryView<K, V>, V>,
InjectableComponent,
Serializable {
    private final BiFunction<? super V, ? super V, ? extends V> remappingFunction;
    private final V value;
    private final Metadata metadata;

    public MergeFunction(V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        this.remappingFunction = remappingFunction;
        this.value = value;
        this.metadata = metadata;
    }

    @ProtoFactory
    MergeFunction(MarshallableObject<V> value, MarshallableObject<BiFunction<? super V, ? super V, ? extends V>> remappingFunction, MarshallableObject<Metadata> metadata) {
        this((V)MarshallableObject.unwrap(value), (BiFunction<? extends V, ? extends V, ? extends V>)MarshallableObject.unwrap(remappingFunction), MarshallableObject.unwrap(metadata));
    }

    @ProtoField(value=1)
    MarshallableObject<V> getValue() {
        return MarshallableObject.create(this.value);
    }

    @ProtoField(value=2)
    MarshallableObject<BiFunction<? super V, ? super V, ? extends V>> getRemappingFunction() {
        return MarshallableObject.create(this.remappingFunction);
    }

    @ProtoField(value=3)
    MarshallableObject<Metadata> getMetadata() {
        return MarshallableObject.create(this.metadata);
    }

    @Override
    public V apply(EntryView.ReadWriteEntryView<K, V> entry) {
        try {
            V merged = this.value;
            if (entry.find().isPresent()) {
                Object t = entry.get();
                if (this.remappingFunction instanceof BiFunctionMapper) {
                    BiFunctionMapper mapper = (BiFunctionMapper)this.remappingFunction;
                    Object toStorage = mapper.getValueDataConversion().toStorage(t);
                    merged = this.remappingFunction.apply(toStorage, this.value);
                } else {
                    merged = this.remappingFunction.apply(t, this.value);
                }
            }
            if (merged == null) {
                entry.set(merged, new MetaParam.Writable[0]);
            } else if (this.remappingFunction instanceof BiFunctionMapper) {
                BiFunctionMapper mapper = (BiFunctionMapper)this.remappingFunction;
                Object fromStorage = mapper.getValueDataConversion().fromStorage(merged);
                entry.set(fromStorage, this.metadata);
            } else {
                entry.set(merged, this.metadata);
            }
            return merged;
        }
        catch (Exception ex) {
            throw new UserRaisedFunctionalException(ex);
        }
    }

    @Override
    public void inject(ComponentRegistry registry) {
        registry.wireDependencies(this);
        registry.wireDependencies(this.remappingFunction);
    }
}

