/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.commands;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.configuration.cache.XSiteStateTransferMode;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.NodeVersion;
import org.infinispan.util.ByteString;
import org.infinispan.xsite.response.AutoStateTransferResponse;
import org.infinispan.xsite.status.SiteState;

@ProtoTypeId(value=1255)
public class XSiteAutoTransferStatusCommand
extends BaseRpcCommand {
    @ProtoField(value=2)
    final String site;

    @ProtoFactory
    public XSiteAutoTransferStatusCommand(ByteString cacheName, String site) {
        super(cacheName);
        this.site = site;
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    public CompletionStage<AutoStateTransferResponse> invokeAsync(ComponentRegistry registry) throws Throwable {
        boolean offline = registry.getTakeOfflineManager().running().getSiteState(this.site) == SiteState.OFFLINE;
        XSiteStateTransferMode mode = registry.getXSiteStateTransferManager().running().stateTransferMode(this.site);
        return CompletableFuture.completedFuture(new AutoStateTransferResponse(offline, mode));
    }

    @Override
    public NodeVersion supportedSince() {
        return NodeVersion.SIXTEEN;
    }

    @Override
    public String toString() {
        return "XSiteAutoTransferStatusCommand{cacheName=" + String.valueOf(this.cacheName) + ", site='" + this.site + "'}";
    }
}

