/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.Transaction;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.cache.impl.InvocationHelper;
import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.IracPutKeyValueCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.RemoveExpiredCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.IllegalLifecycleStateException;
import org.infinispan.commons.TimeoutException;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.commons.util.concurrent.AggregateCompletionStage;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.WriteOnlyMapImpl;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.marshall.core.MarshallableFunctions;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.IracMetadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.remoting.LocalInvocation;
import org.infinispan.remoting.RpcException;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.ValidResponse;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.ResponseCollectors;
import org.infinispan.remoting.transport.impl.MapResponseCollector;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.tm.EmbeddedTransaction;
import org.infinispan.transaction.tm.EmbeddedTransactionManager;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.BackupReceiver;
import org.infinispan.xsite.irac.DiscardUpdateException;
import org.infinispan.xsite.statetransfer.XSiteState;
import org.infinispan.xsite.statetransfer.XSiteStatePushCommand;

@Scope(value=Scopes.NAMED_CACHE)
public class ClusteredCacheBackupReceiver
implements BackupReceiver {
    private static final Log log = LogFactory.getLog(ClusteredCacheBackupReceiver.class);
    private static final BiFunction<Object, Throwable, Void> CHECK_EXCEPTION = (o, throwable) -> {
        if (throwable == null || throwable instanceof DiscardUpdateException) {
            return null;
        }
        throw CompletableFutures.asCompletionException((Throwable)throwable);
    };
    private static final long TRANSACTIONAL_FLAGS = EnumUtil.bitSetOf((Enum)Flag.IGNORE_RETURN_VALUES, (Enum)Flag.SKIP_XSITE_BACKUP);
    @Inject
    Cache<Object, Object> cache;
    @Inject
    TimeService timeService;
    @Inject
    CommandsFactory commandsFactory;
    @Inject
    KeyPartitioner keyPartitioner;
    @Inject
    InvocationHelper invocationHelper;
    @Inject
    InvocationContextFactory invocationContextFactory;
    @Inject
    RpcManager rpcManager;
    @Inject
    ClusteringDependentLogic clusteringDependentLogic;
    private volatile DefaultHandler defaultHandler;

    @Start
    public void start() {
        ComponentRegistry cr = ComponentRegistry.of(this.cache);
        TransactionHandler txHandler = new TransactionHandler(this.cache, cr.getTransactionTable(), this.invocationContextFactory, this.invocationHelper);
        this.defaultHandler = new DefaultHandler(txHandler, cr.getComponent(BlockingManager.class));
    }

    @Override
    public CompletionStage<Void> handleStateTransferControl(String originSite, boolean startReceiving) {
        BaseRpcCommand cmd = startReceiving ? this.commandsFactory.buildXSiteStateTransferStartReceiveCommand(originSite) : this.commandsFactory.buildXSiteStateTransferFinishReceiveCommand(originSite);
        return this.invokeRemotelyInLocalSite(cmd);
    }

    private static PrivateMetadata internalMetadata(IracMetadata metadata) {
        return new PrivateMetadata.Builder().iracMetadata(metadata).build();
    }

    @Override
    public CompletionStage<Void> handleStateTransferState(List<XSiteState> chunk, long timeoutMs) {
        CompletableFuture<Void> allowInvocation = this.checkInvocationAllowedFuture();
        if (allowInvocation != null) {
            return allowInvocation;
        }
        long endTime = this.timeService.expectedEndTime(timeoutMs, TimeUnit.MILLISECONDS);
        HashMap<Address, List> primaryOwnersChunks = new HashMap<Address, List>();
        Address localAddress = this.rpcManager.getAddress();
        if (log.isTraceEnabled()) {
            log.tracef("Received X-Site state transfer %s keys. Splitting by primary owner.", chunk.size());
        }
        for (XSiteState state : chunk) {
            Address primaryOwner = this.clusteringDependentLogic.getCacheTopology().getDistribution(state.key()).primary();
            List list = primaryOwnersChunks.computeIfAbsent(primaryOwner, k -> new LinkedList());
            list.add(state);
        }
        List localChunks = (List)primaryOwnersChunks.remove(localAddress);
        AggregateCompletionStage cf = CompletionStages.aggregateCompletionStage();
        for (Map.Entry entry : primaryOwnersChunks.entrySet()) {
            if (entry.getValue() == null || ((List)entry.getValue()).isEmpty()) continue;
            if (log.isTraceEnabled()) {
                log.tracef("Node '%s' will apply %s", entry.getKey(), entry.getValue());
            }
            StatePushTask task = new StatePushTask((List)entry.getValue(), (Address)entry.getKey(), endTime);
            task.executeRemote();
            cf.dependsOn((CompletionStage)task);
        }
        primaryOwnersChunks.clear();
        if (log.isTraceEnabled()) {
            log.tracef("Local node '%s' will apply %s", localAddress, localChunks);
        }
        if (localChunks != null) {
            StatePushTask task = new StatePushTask(localChunks, localAddress, endTime);
            task.executeLocal();
            cf.dependsOn((CompletionStage)task);
        }
        return cf.freeze().thenApply(this::assertAllowInvocationFunction);
    }

    @Override
    public final <O> CompletionStage<O> handleRemoteCommand(VisitableCommand command) {
        try {
            return (CompletionStage)command.acceptVisitor(null, this.defaultHandler);
        }
        catch (Throwable throwable) {
            return CompletableFuture.failedFuture(throwable);
        }
    }

    @Override
    public CompletionStage<Void> putKeyValue(Object key, Object value, Metadata metadata, IracMetadata iracMetadata) {
        IracPutKeyValueCommand cmd = this.commandsFactory.buildIracPutKeyValueCommand(key, this.segment(key), value, metadata, ClusteredCacheBackupReceiver.internalMetadata(iracMetadata));
        InvocationContext ctx = this.invocationContextFactory.createSingleKeyNonTxInvocationContext();
        return this.invocationHelper.invokeAsync(ctx, cmd).handle(CHECK_EXCEPTION);
    }

    @Override
    public CompletionStage<Void> removeKey(Object key, IracMetadata iracMetadata, boolean expiration) {
        IracPutKeyValueCommand cmd = this.commandsFactory.buildIracPutKeyValueCommand(key, this.segment(key), null, null, ClusteredCacheBackupReceiver.internalMetadata(iracMetadata));
        cmd.setExpiration(expiration);
        InvocationContext ctx = this.invocationContextFactory.createSingleKeyNonTxInvocationContext();
        return this.invocationHelper.invokeAsync(ctx, cmd).handle(CHECK_EXCEPTION);
    }

    private <T> CompletableFuture<T> checkInvocationAllowedFuture() {
        ComponentStatus status = this.cache.getStatus();
        if (!status.allowInvocations()) {
            return CompletableFuture.failedFuture(new IllegalLifecycleStateException("Cache is stopping or terminated: " + String.valueOf((Object)status)));
        }
        return null;
    }

    private Void assertAllowInvocationFunction(Object ignoredRetVal) {
        ComponentStatus status = this.cache.getStatus();
        if (!status.allowInvocations()) {
            throw CompletableFutures.asCompletionException((Throwable)new IllegalLifecycleStateException("Cache is stopping or terminated: " + String.valueOf((Object)status)));
        }
        return null;
    }

    private XSiteStatePushCommand newStatePushCommand(List<XSiteState> stateList) {
        return this.commandsFactory.buildXSiteStatePushCommand(stateList);
    }

    @Override
    public CompletionStage<Void> clearKeys() {
        return this.defaultHandler.cache().clearAsync();
    }

    @Override
    public CompletionStage<Boolean> touchEntry(Object key) {
        return this.cache.getAdvancedCache().touch(key, false);
    }

    public boolean isTransactionTableEmpty() {
        return this.defaultHandler.txHandler.remote2localTx.isEmpty();
    }

    private CompletionStage<Void> invokeRemotelyInLocalSite(CacheRpcCommand command) {
        CompletionStage<Map<Address, Response>> remote = this.rpcManager.invokeCommandOnAll(command, MapResponseCollector.validOnly(), this.rpcManager.getSyncRpcOptions());
        CompletionStage<Response> local = LocalInvocation.newInstanceFromCache(this.cache, command).callAsync();
        return CompletableFuture.allOf(remote.toCompletableFuture(), local.toCompletableFuture());
    }

    private int segment(Object key) {
        return this.keyPartitioner.getSegment(key);
    }

    private static final class TransactionHandler
    extends AbstractVisitor {
        private static final Log log = LogFactory.getLog(TransactionHandler.class);
        private final ConcurrentMap<GlobalTransaction, GlobalTransaction> remote2localTx;
        private final AdvancedCache<Object, Object> backupCache;
        private final FunctionalMap.WriteOnlyMap<Object, Object> writeOnlyMap;
        private final TransactionTable transactionTable;
        private final InvocationContextFactory invocationContextFactory;
        private final InvocationHelper invocationHelper;

        TransactionHandler(Cache<Object, Object> backup, TransactionTable transactionTable, InvocationContextFactory invocationContextFactory, InvocationHelper invocationHelper) {
            this.backupCache = backup.getAdvancedCache().withStorageMediaType().withFlags(Flag.IGNORE_RETURN_VALUES, Flag.SKIP_XSITE_BACKUP);
            this.writeOnlyMap = WriteOnlyMapImpl.create(FunctionalMapImpl.create(this.backupCache));
            this.remote2localTx = new ConcurrentHashMap<GlobalTransaction, GlobalTransaction>();
            this.transactionTable = transactionTable;
            this.invocationContextFactory = invocationContextFactory;
            this.invocationHelper = invocationHelper;
        }

        @Override
        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) {
            if (command.isConditional()) {
                throw new UnsupportedOperationException();
            }
            this.backupCache.put(command.getKey(), command.getValue(), command.getMetadata());
            return null;
        }

        @Override
        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) {
            if (command.isConditional()) {
                throw new UnsupportedOperationException();
            }
            this.backupCache.remove(command.getKey());
            return null;
        }

        @Override
        public Object visitWriteOnlyManyEntriesCommand(InvocationContext ctx, WriteOnlyManyEntriesCommand command) {
            CompletableFuture<Void> future = this.writeOnlyMap.evalMany(command.getArguments(), MarshallableFunctions.setInternalCacheValueConsumer());
            return future.join();
        }

        void handlePrepareCommand(PrepareCommand command) {
            if (!command.hasModifications()) {
                throw new IllegalStateException("TxInvocationContext has no modifications!");
            }
            if (this.isTransactional()) {
                try {
                    this.replayModificationsInTransaction(command, command.isOnePhaseCommit());
                }
                catch (Throwable throwable) {
                    throw CompletableFutures.asCompletionException((Throwable)new CacheException(throwable.getMessage()));
                }
            }
            try {
                this.replayModifications(command);
            }
            catch (Throwable throwable) {
                throw CompletableFutures.asCompletionException((Throwable)throwable);
            }
        }

        void handleCommitCommand(CommitCommand command) {
            if (!this.isTransactional()) {
                log.cannotRespondToCommit(command.getGlobalTransaction(), this.backupCache.getName());
            } else {
                if (log.isTraceEnabled()) {
                    log.tracef("Committing remote transaction %s", command.getGlobalTransaction());
                }
                try {
                    this.completeTransaction(command.getGlobalTransaction(), true);
                }
                catch (Throwable throwable) {
                    throw CompletableFutures.asCompletionException((Throwable)throwable);
                }
            }
        }

        void handleRollbackCommand(RollbackCommand command) {
            if (!this.isTransactional()) {
                log.cannotRespondToRollback(command.getGlobalTransaction(), this.backupCache.getName());
            } else {
                if (log.isTraceEnabled()) {
                    log.tracef("Rolling back remote transaction %s", command.getGlobalTransaction());
                }
                try {
                    this.completeTransaction(command.getGlobalTransaction(), false);
                }
                catch (Throwable throwable) {
                    throw CompletableFutures.asCompletionException((Throwable)throwable);
                }
            }
        }

        @Override
        protected Object handleDefault(InvocationContext ctx, VisitableCommand command) {
            throw new UnsupportedOperationException();
        }

        private boolean isTransactional() {
            return this.transactionTable != null;
        }

        private void completeTransaction(GlobalTransaction globalTransaction, boolean commit) throws Throwable {
            GlobalTransaction globalTx = (GlobalTransaction)this.remote2localTx.remove(globalTransaction);
            if (globalTx == null) {
                if (commit) {
                    throw Log.XSITE.unableToFindRemoteSiteTransaction(globalTransaction);
                }
                return;
            }
            LocalTransaction localTx = this.transactionTable.getLocalTransaction(globalTx);
            if (localTx == null) {
                if (commit) {
                    throw Log.XSITE.unableToFindLocalTransactionFromRemoteSiteTransaction(globalTransaction);
                }
                return;
            }
            EmbeddedTransaction tx = (EmbeddedTransaction)localTx.getTransaction();
            if (!localTx.isEnlisted()) {
                if (log.isTraceEnabled()) {
                    log.tracef("%s isn't enlisted! Removing it manually.", localTx);
                }
                this.transactionTable.removeLocalTransaction(localTx);
            }
            tx.runCommit(!commit);
        }

        private void replayModificationsInTransaction(PrepareCommand command, boolean onePhaseCommit) throws Exception {
            EmbeddedTransaction tx = this.createTransaction();
            LocalTransaction localTx = this.transactionTable.getOrCreateLocalTransaction((Transaction)tx, false);
            this.replayModificationsWithTransaction(tx, localTx, command);
            localTx.setFromRemoteSite(true);
            this.throwExceptionIfFailed(tx, localTx);
            if (onePhaseCommit) {
                this.runOnePhaseCommitAfterPrepare(tx, localTx);
                return;
            }
            try {
                if (tx.runPrepare()) {
                    this.remote2localTx.put(command.getGlobalTransaction(), localTx.getGlobalTransaction());
                    return;
                }
            }
            catch (Throwable t) {
                tx.transactionFailed(t);
            }
            assert (tx.getRollbackException() != null);
            this.throwExceptionIfFailed(tx, localTx);
        }

        private void replayModifications(PrepareCommand command) throws Throwable {
            for (WriteCommand c : command.getModifications()) {
                c.acceptVisitor(null, this);
            }
        }

        private void replayModificationsWithTransaction(EmbeddedTransaction tx, LocalTransaction localTx, PrepareCommand command) {
            LocalTxInvocationContext ctx = this.invocationContextFactory.createTxInvocationContext(localTx);
            AggregateCompletionStage stage = CompletionStages.aggregateCompletionStage();
            try {
                for (WriteCommand c : command.getModifications()) {
                    c.setFlagsBitSet(EnumUtil.mergeBitSets((long)TRANSACTIONAL_FLAGS, (long)c.getFlagsBitSet()));
                    stage.dependsOn(this.invocationHelper.invokeAsync(ctx, c).exceptionally(throwable -> {
                        tx.transactionFailed((Throwable)throwable);
                        return null;
                    }));
                }
                CompletionStages.await((CompletionStage)stage.freeze());
            }
            catch (Throwable t) {
                tx.transactionFailed(t);
            }
        }

        private void throwExceptionIfFailed(EmbeddedTransaction tx, LocalTransaction localTx) throws RollbackException {
            if (tx.getRollbackException() != null) {
                try {
                    tx.rollback();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (!localTx.isEnlisted()) {
                    this.transactionTable.removeLocalTransaction(localTx);
                }
                assert (!this.transactionTable.containsLocalTx(localTx.getGlobalTransaction()));
                throw tx.getRollbackException();
            }
        }

        private void runOnePhaseCommitAfterPrepare(EmbeddedTransaction tx, LocalTransaction localTx) throws HeuristicRollbackException, HeuristicMixedException, RollbackException {
            try {
                tx.commit();
            }
            finally {
                if (!localTx.isEnlisted()) {
                    this.transactionTable.removeLocalTransaction(localTx);
                }
                assert (!this.transactionTable.containsLocalTx(localTx.getGlobalTransaction()));
            }
        }

        private EmbeddedTransaction createTransaction() {
            return new EmbeddedTransaction(EmbeddedTransactionManager.getInstance());
        }
    }

    private static class DefaultHandler
    extends AbstractVisitor {
        final TransactionHandler txHandler;
        final BlockingManager blockingManager;

        private DefaultHandler(TransactionHandler txHandler, BlockingManager blockingManager) {
            this.txHandler = txHandler;
            this.blockingManager = blockingManager;
        }

        @Override
        public CompletionStage<Object> visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) {
            return this.cache().putAsync(command.getKey(), command.getValue(), command.getMetadata());
        }

        @Override
        public CompletionStage<Object> visitRemoveCommand(InvocationContext ctx, RemoveCommand command) {
            return this.cache().removeAsync(command.getKey());
        }

        @Override
        public Object visitRemoveExpiredCommand(InvocationContext ctx, RemoveExpiredCommand command) {
            if (!command.isMaxIdle()) {
                throw new UnsupportedOperationException("Lifespan based expiration is not supported for xsite");
            }
            return this.cache().removeMaxIdleExpired(command.getKey(), command.getValue());
        }

        @Override
        public CompletionStage<Void> visitWriteOnlyManyEntriesCommand(InvocationContext ctx, WriteOnlyManyEntriesCommand command) {
            return this.fMap().evalMany(command.getArguments(), MarshallableFunctions.setInternalCacheValueConsumer());
        }

        @Override
        public final CompletionStage<Void> visitClearCommand(InvocationContext ctx, ClearCommand command) {
            return this.cache().clearAsync();
        }

        @Override
        public CompletionStage<Void> visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) {
            return this.blockingManager.runBlocking(() -> this.txHandler.handlePrepareCommand(command), command.getClass().getSimpleName());
        }

        @Override
        public CompletionStage<Void> visitCommitCommand(TxInvocationContext ctx, CommitCommand command) {
            return this.blockingManager.runBlocking(() -> this.txHandler.handleCommitCommand(command), command.getClass().getSimpleName());
        }

        @Override
        public CompletionStage<Void> visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) {
            return this.blockingManager.runBlocking(() -> this.txHandler.handleRollbackCommand(command), command.getClass().getSimpleName());
        }

        @Override
        protected final Object handleDefault(InvocationContext ctx, VisitableCommand command) {
            throw new UnsupportedOperationException();
        }

        private AdvancedCache<Object, Object> cache() {
            return this.txHandler.backupCache;
        }

        private FunctionalMap.WriteOnlyMap<Object, Object> fMap() {
            return this.txHandler.writeOnlyMap;
        }
    }

    private class StatePushTask
    extends CompletableFuture<Void>
    implements ResponseCollector<Address, Response>,
    BiFunction<Response, Throwable, Void> {
        private final List<XSiteState> chunk;
        private final Address address;
        private final long endTime;

        private StatePushTask(List<XSiteState> chunk, Address address, long endTime) {
            this.chunk = chunk;
            this.address = address;
            this.endTime = endTime;
        }

        @Override
        public Void apply(Response response, Throwable throwable) {
            if (throwable != null) {
                if (this.isShouldGiveUp()) {
                    return null;
                }
                if (ClusteredCacheBackupReceiver.this.rpcManager.getMembers().contains(this.address) && !ClusteredCacheBackupReceiver.this.rpcManager.getAddress().equals(this.address)) {
                    if (log.isTraceEnabled()) {
                        log.tracef(throwable, "An exception was sent by %s. Retrying!", this.address);
                    }
                    this.executeRemote();
                } else {
                    if (log.isTraceEnabled()) {
                        log.tracef(throwable, "An exception was sent by %s. Retrying locally!", this.address);
                    }
                    this.executeLocal();
                }
            } else if (response == CacheNotFoundResponse.INSTANCE) {
                if (log.isTraceEnabled()) {
                    log.tracef("Cache not found in node '%s'. Retrying locally!", this.address);
                }
                if (this.isShouldGiveUp()) {
                    return null;
                }
                this.executeLocal();
            } else {
                this.complete(null);
            }
            return null;
        }

        @Override
        public Response addResponse(Address sender, Response response) {
            if (response instanceof ValidResponse || response instanceof CacheNotFoundResponse) {
                return response;
            }
            if (response instanceof ExceptionResponse) {
                throw ResponseCollectors.wrapRemoteException(sender, ((ExceptionResponse)response).getException());
            }
            throw ResponseCollectors.wrapRemoteException(sender, (Throwable)((Object)new RpcException("Unknown response type: " + String.valueOf(response))));
        }

        @Override
        public Response finish() {
            return null;
        }

        private void executeRemote() {
            RpcOptions rpcOptions = ClusteredCacheBackupReceiver.this.rpcManager.getSyncRpcOptions();
            ClusteredCacheBackupReceiver.this.rpcManager.invokeCommand(this.address, (CacheRpcCommand)ClusteredCacheBackupReceiver.this.newStatePushCommand(this.chunk), this, rpcOptions).handle(this);
        }

        private void executeLocal() {
            LocalInvocation.newInstanceFromCache(ClusteredCacheBackupReceiver.this.cache, ClusteredCacheBackupReceiver.this.newStatePushCommand(this.chunk)).callAsync().handle(this);
        }

        private boolean isShouldGiveUp() {
            ComponentStatus status = ClusteredCacheBackupReceiver.this.cache.getStatus();
            if (!status.allowInvocations()) {
                this.completeExceptionally(new IllegalLifecycleStateException("Cache is stopping or terminated: " + String.valueOf((Object)status)));
                return true;
            }
            if (ClusteredCacheBackupReceiver.this.timeService.isTimeExpired(this.endTime)) {
                this.completeExceptionally(new TimeoutException("Unable to apply state in the time limit."));
                return true;
            }
            return false;
        }
    }
}

