/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa;

import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.xa.Xid;
import org.infinispan.commands.RequestUUID;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.Address;

@ProtoTypeId(value=1084)
public class GlobalTransaction
implements Cloneable {
    private static final AtomicLong sid = new AtomicLong(0L);
    private final RequestUUID requestUUID;
    private int hash_code = -1;
    private boolean remote = false;
    private final boolean clientTx;
    private volatile XidImpl xid = null;
    private volatile long internalId = -1L;

    public GlobalTransaction(Address addr, boolean remote) {
        this(addr, remote, false);
    }

    public GlobalTransaction(Address addr, boolean remote, boolean clientTx) {
        this.requestUUID = addr == null ? RequestUUID.localOf(sid.incrementAndGet()) : RequestUUID.of(addr, sid.incrementAndGet());
        this.remote = remote;
        this.clientTx = clientTx;
    }

    @ProtoFactory
    GlobalTransaction(RequestUUID requestUUID, XidImpl xid, long internalId, boolean clientTransaction) {
        this.requestUUID = requestUUID;
        this.xid = xid;
        this.internalId = internalId;
        this.clientTx = clientTransaction;
    }

    public Address getAddress() {
        return this.requestUUID.toAddress();
    }

    public long getId() {
        return this.requestUUID.getRequestId();
    }

    @ProtoField(value=1)
    public RequestUUID getRequestUUID() {
        return this.requestUUID;
    }

    @ProtoField(value=2)
    public XidImpl getXid() {
        return this.xid;
    }

    @ProtoField(value=3)
    public long getInternalId() {
        return this.internalId;
    }

    @ProtoField(value=4)
    public boolean isClientTransaction() {
        return this.clientTx;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public void setRemote(boolean remote) {
        this.remote = remote;
    }

    public GlobalTransaction changeAddress(Address address) {
        return new GlobalTransaction(this.requestUUID.asNodeUUID(address.getNodeUUID()), this.getXid(), this.getInternalId(), this.isClientTransaction());
    }

    public int hashCode() {
        if (this.hash_code == -1) {
            this.hash_code = this.requestUUID.hashCode();
        }
        return this.hash_code;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GlobalTransaction)) {
            return false;
        }
        GlobalTransaction otherGtx = (GlobalTransaction)other;
        return this.requestUUID.equals(otherGtx.requestUUID);
    }

    public final String globalId() {
        return this.requestUUID.toIdString();
    }

    public void setXid(Xid xid) {
        this.xid = XidImpl.copy((Xid)xid);
    }

    public void setInternalId(long internalId) {
        this.internalId = internalId;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Impossible!");
        }
    }

    public String toString() {
        return "GlobalTransaction{id=" + this.getId() + ", addr=" + String.valueOf(this.getAddress()) + ", remote=" + this.remote + ", xid=" + String.valueOf(this.xid) + ", internalId=" + this.internalId + "}";
    }
}

