/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.IllegalLifecycleStateException;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.context.Flag;
import org.infinispan.eviction.impl.PassivationManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.impl.CacheLoaderInterceptor;
import org.infinispan.interceptors.impl.CacheMgmtInterceptor;
import org.infinispan.interceptors.impl.CacheWriterInterceptor;
import org.infinispan.interceptors.impl.InvalidationInterceptor;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.MeasurementType;
import org.infinispan.jmx.annotations.Units;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.Address;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.stats.ClusterCacheStats;
import org.infinispan.stats.impl.AbstractClusterStats;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.function.TriConsumer;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="ClusterCacheStats", description="General cluster statistics such as timings, hit/miss ratio, etc. for a cache.")
@Scope(value=Scopes.NAMED_CACHE)
public class ClusterCacheStatsImpl
extends AbstractClusterStats
implements ClusterCacheStats {
    private static final String[] LONG_ATTRIBUTES = new String[]{"evictions", "hits", "misses", "offHeapMemoryUsed", "removeHits", "removeMisses", "invalidations", "passivations", "cacheLoaderLoads", "cacheLoaderMisses", "cacheWriterStores", "stores", "dataMemoryUsed"};
    private static final Log log = LogFactory.getLog(ClusterCacheStatsImpl.class);
    @Inject
    AdvancedCache<?, ?> cache;
    @Inject
    Configuration cacheConfiguration;
    @Inject
    GlobalConfiguration globalConfiguration;
    ClusterExecutor clusterExecutor;
    private double readWriteRatio;
    private double hitRatio;

    public ClusterCacheStatsImpl() {
        super(log);
    }

    @Override
    public void start() {
        this.statisticsEnabled = this.cacheConfiguration.statistics().enabled();
        this.clusterExecutor = SecurityActions.getClusterExecutor(this.cache);
    }

    @Override
    void updateStats() {
        if (this.clusterExecutor == null) {
            return;
        }
        ConcurrentHashMap resultMap = new ConcurrentHashMap();
        TriConsumer<Address, Map, Throwable> triConsumer = (a, v, t) -> {
            if (t != null) {
                if (t instanceof CacheConfigurationException || t instanceof IllegalLifecycleStateException) {
                    log.tracef((Throwable)t, "Exception encountered on %s whilst trying to calculate stats for cache %s", a, this.cache.getName());
                    return;
                }
                throw new CacheException(t);
            }
            if (a == null) {
                a = Address.LOCAL;
            }
            if (!v.isEmpty()) {
                resultMap.put(a, v);
            }
        };
        boolean accurateSize = this.globalConfiguration.metrics().accurateSize();
        DistributedCacheStatsCallable task = new DistributedCacheStatsCallable(this.cache.getName(), accurateSize);
        try {
            CompletableFuture<Void> future = this.clusterExecutor.submitConsumer(task, triConsumer);
            future.join();
            Collection<Map<String, Number>> responseList = resultMap.values();
            for (String att : LONG_ATTRIBUTES) {
                this.putLongAttributes(responseList, att);
            }
            this.putLongAttributesAverage(responseList, "averageWriteTime");
            this.putLongAttributesAverage(responseList, "averageWriteTimeNanos");
            this.putLongAttributesAverage(responseList, "averageReadTime");
            this.putLongAttributesAverage(responseList, "averageReadTimeNanos");
            this.putLongAttributesAverage(responseList, "averageRemoveTime");
            this.putLongAttributesAverage(responseList, "averageRemoveTimeNanos");
            this.putLongAttributesAverage(responseList, "offHeapMemoryUsed");
            this.putIntAttributes(responseList, "numberOfLocksHeld");
            this.putIntAttributes(responseList, "numberOfLocksAvailable");
            this.putIntAttributesMax(responseList, "minRequiredNodes");
            this.putLongAttributes(responseList, "approximateEntries");
            this.putLongAttributes(responseList, "approximateEntriesInMemory");
            this.putLongAttributes(responseList, "approximateEntriesUnique");
            if (accurateSize) {
                long numberOfEntriesInMemory = this.cache.withFlags(Flag.SKIP_CACHE_LOAD).size();
                this.statsMap.put("numberOfEntriesInMemory", numberOfEntriesInMemory);
                int numberOfEntries = this.cache.size();
                this.statsMap.put("numberOfEntries", Long.valueOf(numberOfEntries));
            } else {
                this.statsMap.put("numberOfEntriesInMemory", -1L);
                this.statsMap.put("numberOfEntries", -1L);
            }
            this.updateTimeSinceStart(responseList);
            this.updateRatios(responseList);
        }
        catch (CompletionException e) {
            log.debug("Error while collecting cluster-wide cache stats", e.getCause());
        }
    }

    @Override
    @ManagedAttribute(description="Average number of milliseconds for a read operation on the cache across the cluster", displayName="Cluster-wide total average read time (ms)", units=Units.MILLISECONDS, clusterWide=true)
    public long getAverageReadTime() {
        return this.getStatAsLong("averageReadTime");
    }

    @Override
    @ManagedAttribute(description="Average number of nanoseconds for a read operation on the cache across the cluster", displayName="Cluster-wide average read time (ns)", units=Units.NANOSECONDS, clusterWide=true)
    public long getAverageReadTimeNanos() {
        return this.getStatAsLong("averageReadTimeNanos");
    }

    @Override
    @ManagedAttribute(description="Average number of milliseconds for a remove operation in the cache across the cluster", displayName="Cluster-wide average remove time (ms)", units=Units.MILLISECONDS, clusterWide=true)
    public long getAverageRemoveTime() {
        return this.getStatAsLong("averageRemoveTime");
    }

    @Override
    @ManagedAttribute(description="Average number of nanoseconds for a remove operation in the cache across the cluster", displayName="Cluster-wide average remove time (ns)", units=Units.NANOSECONDS, clusterWide=true)
    public long getAverageRemoveTimeNanos() {
        return this.getStatAsLong("averageRemoveTimeNanos");
    }

    @Override
    @ManagedAttribute(description="Average number of milliseconds for a write operation in the cache across the cluster", displayName="Cluster-wide average write time (ms)", units=Units.MILLISECONDS, clusterWide=true)
    public long getAverageWriteTime() {
        return this.getStatAsLong("averageWriteTime");
    }

    @Override
    @ManagedAttribute(description="Average number of nanoseconds for a write operation in the cache across the cluster", displayName="Cluster-wide average write time (ns)", units=Units.NANOSECONDS, clusterWide=true)
    public long getAverageWriteTimeNanos() {
        return this.getStatAsLong("averageWriteTimeNanos");
    }

    @Override
    @ManagedAttribute(description="Minimum number of nodes to avoid losing data", displayName="Required minimum number of nodes", clusterWide=true)
    public int getRequiredMinimumNumberOfNodes() {
        return this.getStatAsInt("minRequiredNodes");
    }

    @Override
    @ManagedAttribute(description="Total number of cache eviction operations across the cluster", displayName="Cluster-wide total number of cache evictions", measurementType=MeasurementType.TRENDSUP, clusterWide=true)
    public long getEvictions() {
        return this.getStatAsLong("evictions");
    }

    @Override
    @ManagedAttribute(description="Total number of cache read hits across the cluster", displayName="Cluster-wide total number of cache read hits", measurementType=MeasurementType.TRENDSUP, clusterWide=true)
    public long getHits() {
        return this.getStatAsLong("hits");
    }

    @Override
    @ManagedAttribute(description="Percentage hit/(hit+miss) ratio for this cache", displayName="Cluster-wide hit ratio", units=Units.PERCENTAGE, clusterWide=true)
    public double getHitRatio() {
        if (this.isStatisticsEnabled()) {
            this.fetchStatsIfNeeded();
            return this.hitRatio;
        }
        return -1.0;
    }

    @Override
    @ManagedAttribute(description="Total number of cache read misses", displayName="Cluster-wide number of cache read misses", measurementType=MeasurementType.TRENDSUP, clusterWide=true)
    public long getMisses() {
        return this.getStatAsLong("misses");
    }

    @Override
    @ManagedAttribute(description="Approximate number of entry replicas in the cache across the cluster, including passivated entries", displayName="Cluster-wide approximate number of entry replicas", clusterWide=true)
    public long getApproximateEntries() {
        return this.getStatAsLong("approximateEntries");
    }

    @Override
    @ManagedAttribute(description="Approximate number of entry replicas in memory across the cluster", displayName="Cluster-wide approximate number of entry replicas in memory", clusterWide=true)
    public long getApproximateEntriesInMemory() {
        return this.getStatAsLong("approximateEntriesInMemory");
    }

    @Override
    @ManagedAttribute(description="Approximate number of unique entries in the cache across the cluster, ignoring duplicate replicas", displayName="Cluster-wide approximate number of unique entries", clusterWide=true)
    public long getApproximateEntriesUnique() {
        return this.getStatAsLong("approximateEntriesUnique");
    }

    @ManagedAttribute(description="Current number of entries in the cache across the cluster, including passivated entries", displayName="Cluster-wide number of current cache entries", clusterWide=true)
    public int getNumberOfEntries() {
        return this.getStatAsInt("numberOfEntries");
    }

    @Override
    @ManagedAttribute(description="Current number of entries in memory across the cluster", displayName="Cluster-wide number of entries in memory", clusterWide=true)
    public int getCurrentNumberOfEntriesInMemory() {
        return this.getStatAsInt("numberOfEntriesInMemory");
    }

    @Override
    @ManagedAttribute(description="Cluster-wide read/writes ratio for the cache", displayName="Cluster-wide read/write ratio", units=Units.PERCENTAGE, clusterWide=true)
    public double getReadWriteRatio() {
        if (this.isStatisticsEnabled()) {
            this.fetchStatsIfNeeded();
            return this.readWriteRatio;
        }
        return -1.0;
    }

    @Override
    @ManagedAttribute(description="Cluster-wide total number of cache removal hits", displayName="Cluster-wide total number of cache removal hits", measurementType=MeasurementType.TRENDSUP, clusterWide=true)
    public long getRemoveHits() {
        return this.getStatAsLong("removeHits");
    }

    @Override
    @ManagedAttribute(description="Cluster-wide total number of cache removals where keys were not found", displayName="Cluster-wide total number of cache removal misses", measurementType=MeasurementType.TRENDSUP, clusterWide=true)
    public long getRemoveMisses() {
        return this.getStatAsLong("removeMisses");
    }

    @Override
    @ManagedAttribute(description="Cluster-wide total number of cache put operations", displayName="Cluster-wide total number of cache puts", measurementType=MeasurementType.TRENDSUP, clusterWide=true)
    public long getStores() {
        return this.getStatAsLong("stores");
    }

    @Override
    @ManagedAttribute(description="Number of seconds since the first cache node started", displayName="Number of seconds since the first cache node started", measurementType=MeasurementType.TRENDSUP, clusterWide=true)
    public long getTimeSinceStart() {
        return this.getStatAsLong("timeSinceStart");
    }

    @Override
    public int getCurrentNumberOfEntries() {
        return this.getNumberOfEntries();
    }

    @Override
    @ManagedAttribute(description="Amount in bytes of memory used across the cluster for entries in this cache with eviction", displayName="Cluster-wide memory used by eviction", clusterWide=true)
    public long getDataMemoryUsed() {
        return this.getStatAsLong("dataMemoryUsed");
    }

    @Override
    @ManagedAttribute(description="Amount in bytes of off-heap memory used across the cluster for this cache", displayName="Cluster-wide off-heap memory used", clusterWide=true)
    public long getOffHeapMemoryUsed() {
        return this.getStatAsLong("offHeapMemoryUsed");
    }

    @Override
    public long getRetrievals() {
        return this.getHits() + this.getMisses();
    }

    @Override
    public void reset() {
        super.reset();
        this.readWriteRatio = 0.0;
        this.hitRatio = 0.0;
    }

    @Override
    @ManagedAttribute(description="Current number of exclusive locks available across the cluster", displayName="Cluster-wide number of locks available", clusterWide=true)
    public int getNumberOfLocksAvailable() {
        return this.getStatAsInt("numberOfLocksAvailable");
    }

    @Override
    @ManagedAttribute(description="Current number of locks held across the cluster", displayName="Cluster-wide number of locks held", clusterWide=true)
    public int getNumberOfLocksHeld() {
        return this.getStatAsInt("numberOfLocksHeld");
    }

    @Override
    @ManagedAttribute(description="The total number of invalidations in the cluster", displayName="Cluster-wide total number of invalidations", measurementType=MeasurementType.TRENDSUP, clusterWide=true)
    public long getInvalidations() {
        return this.getStatAsLong("invalidations");
    }

    @Override
    @ManagedAttribute(description="The total number of activations across the cluster", displayName="Cluster-wide total number of activations. This attribute is deprecated and its value is always zero.", measurementType=MeasurementType.TRENDSUP, clusterWide=true)
    public long getActivations() {
        return 0L;
    }

    @Override
    @ManagedAttribute(description="The total number of passivations across the cluster", displayName="Cluster-wide total number of passivations", measurementType=MeasurementType.TRENDSUP, clusterWide=true)
    public long getPassivations() {
        return this.getStatAsLong("passivations");
    }

    @Override
    @ManagedAttribute(description="The total number of persistence load operations in the cluster", displayName="Cluster-wide total number of persistence loads", measurementType=MeasurementType.TRENDSUP, clusterWide=true)
    public long getCacheLoaderLoads() {
        return this.getStatAsLong("cacheLoaderLoads");
    }

    @Override
    @ManagedAttribute(description="The total number of cacheloader load misses in the cluster", displayName="Cluster-wide total number of cacheloader misses", measurementType=MeasurementType.TRENDSUP, clusterWide=true)
    public long getCacheLoaderMisses() {
        return this.getStatAsLong("cacheLoaderMisses");
    }

    @Override
    @ManagedAttribute(description="The total number of cachestore store operations in the cluster", displayName="Cluster-wide total number of cachestore stores", measurementType=MeasurementType.TRENDSUP, clusterWide=true)
    public long getStoreWrites() {
        return this.getStatAsLong("cacheWriterStores");
    }

    private void updateTimeSinceStart(Collection<Map<String, Number>> responseList) {
        long timeSinceStartMax = 0L;
        for (Map<String, Number> m : responseList) {
            Number timeSinceStart = m.get("timeSinceStart");
            if (timeSinceStart.longValue() <= timeSinceStartMax) continue;
            timeSinceStartMax = timeSinceStart.longValue();
        }
        this.statsMap.put("timeSinceStart", timeSinceStartMax);
    }

    private void updateRatios(Collection<Map<String, Number>> responseList) {
        long totalHits = 0L;
        long totalRetrievals = 0L;
        long sumOfAllReads = 0L;
        long sumOfAllWrites = 0L;
        for (Map<String, Number> m : responseList) {
            long hits = m.get("hits").longValue();
            long misses = m.get("misses").longValue();
            sumOfAllReads += (totalHits += hits) + misses;
            sumOfAllWrites += m.get("stores").longValue();
            totalRetrievals += hits + misses;
        }
        this.hitRatio = totalRetrievals > 0L ? (double)totalHits / (double)totalRetrievals : 0.0;
        this.readWriteRatio = sumOfAllWrites > 0L ? (double)sumOfAllReads / (double)sumOfAllWrites : 0.0;
    }

    private static <T extends AsyncInterceptor> T getFirstInterceptorWhichExtends(AdvancedCache<?, ?> cache, Class<T> interceptorClass) {
        return ComponentRegistry.of(cache).getInterceptorChain().wired().findInterceptorExtending(interceptorClass);
    }

    @ProtoTypeId(value=1070)
    public static class DistributedCacheStatsCallable
    implements Function<EmbeddedCacheManager, Map<String, Number>> {
        @ProtoField(value=1)
        final String cacheName;
        @ProtoField(value=2)
        final boolean accurateSize;

        @ProtoFactory
        DistributedCacheStatsCallable(String cacheName, boolean accurateSize) {
            this.cacheName = cacheName;
            this.accurateSize = accurateSize;
        }

        @Override
        public Map<String, Number> apply(EmbeddedCacheManager embeddedCacheManager) {
            if (!embeddedCacheManager.cacheExists(this.cacheName)) {
                return Collections.emptyMap();
            }
            AdvancedCache remoteCache = SecurityActions.getUnwrappedCache(embeddedCacheManager.getCache(this.cacheName)).getAdvancedCache();
            CacheMgmtInterceptor stats = ClusterCacheStatsImpl.getFirstInterceptorWhichExtends(remoteCache, CacheMgmtInterceptor.class);
            HashMap<String, Number> map = new HashMap<String, Number>();
            map.put("averageReadTime", stats.getAverageReadTime());
            map.put("averageReadTimeNanos", stats.getAverageReadTimeNanos());
            map.put("averageWriteTime", stats.getAverageWriteTime());
            map.put("averageWriteTimeNanos", stats.getAverageWriteTimeNanos());
            map.put("averageRemoveTime", stats.getAverageRemoveTime());
            map.put("averageRemoveTimeNanos", stats.getAverageRemoveTimeNanos());
            map.put("evictions", stats.getEvictions());
            map.put("hits", stats.getHits());
            map.put("misses", stats.getMisses());
            map.put("approximateEntries", stats.getApproximateEntries());
            map.put("approximateEntriesInMemory", stats.getApproximateEntriesInMemory());
            map.put("approximateEntriesUnique", stats.getApproximateEntriesUnique());
            map.put("dataMemoryUsed", stats.getDataMemoryUsed());
            map.put("offHeapMemoryUsed", stats.getOffHeapMemoryUsed());
            map.put("minRequiredNodes", stats.getRequiredMinimumNumberOfNodes());
            map.put("stores", stats.getStores());
            map.put("removeHits", stats.getRemoveHits());
            map.put("removeMisses", stats.getRemoveMisses());
            map.put("timeSinceStart", stats.getTimeSinceStart());
            LockManager lockManager = remoteCache.getLockManager();
            map.put("numberOfLocksHeld", lockManager.getNumberOfLocksHeld());
            map.put("numberOfLocksAvailable", 0);
            InvalidationInterceptor invalidationInterceptor = ClusterCacheStatsImpl.getFirstInterceptorWhichExtends(remoteCache, InvalidationInterceptor.class);
            if (invalidationInterceptor != null) {
                map.put("invalidations", invalidationInterceptor.getInvalidations());
            } else {
                map.put("invalidations", 0);
            }
            PassivationManager pManager = ComponentRegistry.componentOf(remoteCache, PassivationManager.class);
            if (pManager != null) {
                map.put("passivations", pManager.getPassivations());
            } else {
                map.put("passivations", 0);
            }
            CacheLoaderInterceptor aInterceptor = ClusterCacheStatsImpl.getFirstInterceptorWhichExtends(remoteCache, CacheLoaderInterceptor.class);
            if (aInterceptor != null) {
                map.put("cacheLoaderLoads", aInterceptor.getCacheLoaderLoads());
                map.put("cacheLoaderMisses", aInterceptor.getCacheLoaderMisses());
            } else {
                map.put("cacheLoaderLoads", 0);
                map.put("cacheLoaderMisses", 0);
            }
            CacheWriterInterceptor interceptor = ClusterCacheStatsImpl.getFirstInterceptorWhichExtends(remoteCache, CacheWriterInterceptor.class);
            if (interceptor != null) {
                map.put("cacheWriterStores", interceptor.getWritesToTheStores());
            } else {
                map.put("cacheWriterStores", 0);
            }
            return map;
        }
    }
}

