/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.infinispan.executors.LazyInitializingBlockingTaskAwareExecutorService;
import org.infinispan.util.concurrent.BlockingTaskAwareExecutorServiceImpl;
import org.jgroups.stack.DiagnosticsHandler;

class ThreadPoolProbeHandler
implements DiagnosticsHandler.ProbeHandler {
    private static final String KEY = "ispn-remote";
    private volatile ExecutorService executor;

    ThreadPoolProbeHandler() {
    }

    public Map<String, String> handleProbe(String ... keys) {
        if (keys == null || keys.length == 0) {
            return null;
        }
        ThreadPoolExecutor exec = ThreadPoolProbeHandler.extract(this.executor);
        if (exec == null || !Arrays.asList(keys).contains(KEY)) {
            return null;
        }
        return Map.of("active-thread", String.valueOf(exec.getActiveCount()), "min-thread", String.valueOf(exec.getCorePoolSize()), "max-thread", String.valueOf(exec.getMaximumPoolSize()), "current-pool-size", String.valueOf(exec.getPoolSize()), "largest-pool-size", String.valueOf(exec.getLargestPoolSize()), "keep-alive", String.valueOf(exec.getKeepAliveTime(TimeUnit.MILLISECONDS)), "queue-size", String.valueOf(exec.getQueue().size()));
    }

    public String[] supportedKeys() {
        return new String[]{KEY};
    }

    void updateThreadPool(ExecutorService executorService) {
        if (executorService != null) {
            this.executor = executorService;
        }
    }

    private static ThreadPoolExecutor extract(ExecutorService service) {
        if (service instanceof ThreadPoolExecutor) {
            return (ThreadPoolExecutor)service;
        }
        if (service instanceof BlockingTaskAwareExecutorServiceImpl) {
            return ThreadPoolProbeHandler.extract(((BlockingTaskAwareExecutorServiceImpl)service).getExecutorService());
        }
        if (service instanceof LazyInitializingBlockingTaskAwareExecutorService) {
            return ThreadPoolProbeHandler.extract(((LazyInitializingBlockingTaskAwareExecutorService)service).getExecutorService());
        }
        return null;
    }
}

