/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.responses;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.container.versioning.IncrementableEntryVersion;
import org.infinispan.marshall.protostream.impl.MarshallableMap;
import org.infinispan.metadata.impl.IracMetadata;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.responses.ValidResponse;
import org.infinispan.transaction.impl.WriteSkewHelper;

@ProtoTypeId(value=46)
public class PrepareResponse
implements ValidResponse<Void> {
    private Map<Object, IncrementableEntryVersion> newWriteSkewVersions;
    private Map<Integer, IracMetadata> newIracMetadata;

    public static PrepareResponse asPrepareResponse(Object rv) {
        assert (rv == null || rv instanceof PrepareResponse);
        return rv == null ? new PrepareResponse() : (PrepareResponse)rv;
    }

    public PrepareResponse() {
    }

    @ProtoFactory
    PrepareResponse(MarshallableMap<Object, IncrementableEntryVersion> newWriteSkewVersions, Map<Integer, IracMetadata> newIracMetadata) {
        this.newWriteSkewVersions = MarshallableMap.unwrap(newWriteSkewVersions);
        this.newIracMetadata = newIracMetadata;
    }

    @ProtoField(value=1)
    MarshallableMap<Object, IncrementableEntryVersion> getNewWriteSkewVersions() {
        return MarshallableMap.create(this.newWriteSkewVersions);
    }

    @ProtoField(value=2)
    Map<Integer, IracMetadata> getNewIracMetadata() {
        return this.newIracMetadata;
    }

    @Override
    public Void getResponseValue() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "PrepareResponse{WriteSkewVersions=" + String.valueOf(this.newWriteSkewVersions) + ", IracMetadataMap=" + String.valueOf(this.newIracMetadata) + "}";
    }

    public IracMetadata getIracMetadata(int segment) {
        return this.newIracMetadata != null ? this.newIracMetadata.get(segment) : null;
    }

    public void setNewIracMetadata(Map<Integer, IracMetadata> map) {
        this.newIracMetadata = map;
    }

    public void merge(PrepareResponse remote) {
        if (remote.newWriteSkewVersions != null) {
            this.mergeEntryVersions(remote.newWriteSkewVersions);
        }
        if (remote.newIracMetadata != null) {
            if (this.newIracMetadata == null) {
                this.newIracMetadata = new HashMap<Integer, IracMetadata>(remote.newIracMetadata);
            } else {
                this.newIracMetadata.putAll(remote.newIracMetadata);
            }
        }
    }

    public Map<Object, IncrementableEntryVersion> mergeEntryVersions(Map<Object, IncrementableEntryVersion> entryVersions) {
        if (this.newWriteSkewVersions == null) {
            this.newWriteSkewVersions = new HashMap<Object, IncrementableEntryVersion>();
        }
        this.newWriteSkewVersions = WriteSkewHelper.mergeEntryVersions(this.newWriteSkewVersions, entryVersions);
        return this.newWriteSkewVersions;
    }
}

