/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.inboundhandler;

import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.remote.ClusteredGetAllCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.remoting.inboundhandler.DefaultTopologyRunnable;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.PerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.remoting.inboundhandler.TopologyMode;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.ResponseGenerator;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.util.concurrent.BlockingRunnable;
import org.infinispan.util.concurrent.BlockingTaskAwareExecutorService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NAMED_CACHE)
public abstract class BasePerCacheInboundInvocationHandler
implements PerCacheInboundInvocationHandler {
    private static final Log log = LogFactory.getLog(BasePerCacheInboundInvocationHandler.class);
    private static final int NO_TOPOLOGY_COMMAND = Integer.MIN_VALUE;
    @Inject
    @ComponentName(value="org.infinispan.executors.blocking")
    protected BlockingTaskAwareExecutorService blockingExecutor;
    @Inject
    @ComponentName(value="org.infinispan.executors.non-blocking")
    protected BlockingTaskAwareExecutorService nonBlockingExecutor;
    @Inject
    StateTransferLock stateTransferLock;
    @Inject
    ResponseGenerator responseGenerator;
    @Inject
    ComponentRegistry componentRegistry;
    @Inject
    protected Configuration configuration;
    @Inject
    RpcManager rpcManager;
    private volatile boolean stopped;
    private volatile int firstTopologyAsMember = Integer.MAX_VALUE;

    static int extractCommandTopologyId(CacheRpcCommand command) {
        if (command instanceof ClusteredGetCommand || command instanceof ClusteredGetAllCommand) {
            return Integer.MIN_VALUE;
        }
        return BasePerCacheInboundInvocationHandler.topology(command);
    }

    private static int topology(ReplicableCommand cmd) {
        int n;
        if (cmd instanceof TopologyAffectedCommand) {
            TopologyAffectedCommand tac = (TopologyAffectedCommand)cmd;
            n = tac.getTopologyId();
        } else {
            n = Integer.MIN_VALUE;
        }
        return n;
    }

    @Start
    public void start() {
        this.stopped = false;
    }

    @Stop
    public void stop() {
        this.stopped = true;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    final CompletableFuture<Response> invokeCommand(CacheRpcCommand cmd) throws Throwable {
        CompletableFuture<?> future;
        if (log.isTraceEnabled()) {
            log.tracef("Calling invokeAsync() on %s", cmd);
        }
        if (CompletionStages.isCompletedSuccessfully(future = cmd.invokeAsync(this.componentRegistry).toCompletableFuture())) {
            Object obj = future.join();
            Response response = this.responseGenerator.getResponse(cmd, obj);
            if (response == null) {
                return CompletableFutures.completedNull();
            }
            return CompletableFuture.completedFuture(response);
        }
        return future.handle((rv, throwable) -> {
            CompletableFutures.rethrowExceptionIfPresent((Throwable)throwable);
            return this.responseGenerator.getResponse(cmd, rv);
        });
    }

    final StateTransferLock getStateTransferLock() {
        return this.stateTransferLock;
    }

    static ExceptionResponse exceptionHandlingCommand(CacheRpcCommand command, Throwable throwable) {
        if (command.logThrowable(throwable)) {
            Log.CLUSTER.exceptionHandlingCommand(command, throwable);
        }
        if (throwable instanceof Exception) {
            return new ExceptionResponse((Exception)throwable);
        }
        return new ExceptionResponse((Exception)((Object)new CacheException("Problems invoking command.", throwable)));
    }

    static ExceptionResponse outdatedTopology(OutdatedTopologyException exception) {
        log.tracef("Topology changed, retrying: %s", (Object)exception);
        return new ExceptionResponse((Exception)((Object)exception));
    }

    static Response interruptedException(CacheRpcCommand command) {
        Log.CLUSTER.debugf("Shutdown while handling command %s", command);
        return CacheNotFoundResponse.INSTANCE;
    }

    final void handleRunnable(BlockingRunnable runnable, boolean onExecutorService) {
        if (onExecutorService) {
            this.blockingExecutor.execute(runnable);
        } else {
            runnable.run();
        }
    }

    public final boolean isCommandSentBeforeFirstTopology(int commandTopologyId) {
        if (0 <= commandTopologyId && commandTopologyId < this.firstTopologyAsMember) {
            if (log.isTraceEnabled()) {
                log.tracef("Ignoring command sent before the local node was a member (command topology id is %d, first topology as member is %d)", commandTopologyId, this.firstTopologyAsMember);
            }
            return true;
        }
        return false;
    }

    final BlockingRunnable createDefaultRunnable(CacheRpcCommand command, Reply reply, int commandTopologyId, boolean waitTransactionalData, boolean onExecutorService, boolean sync) {
        return new DefaultTopologyRunnable(this, command, reply, TopologyMode.create(onExecutorService, waitTransactionalData), commandTopologyId, sync);
    }

    final BlockingRunnable createDefaultRunnable(CacheRpcCommand command, Reply reply, int commandTopologyId, TopologyMode topologyMode, boolean sync) {
        return new DefaultTopologyRunnable(this, command, reply, topologyMode, commandTopologyId, sync);
    }

    static boolean executeOnExecutorService(DeliverOrder order, CacheRpcCommand command) {
        return false;
    }

    @Override
    public void setFirstTopologyAsMember(int firstTopologyAsMember) {
        this.firstTopologyAsMember = firstTopologyAsMember;
    }

    @Override
    public int getFirstTopologyAsMember() {
        return this.firstTopologyAsMember;
    }

    @Override
    public void checkForReadyTasks() {
        this.blockingExecutor.checkForReadyTasks();
        this.nonBlockingExecutor.checkForReadyTasks();
    }
}

