/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.reactive.publisher.impl.commands.batch;

import java.util.concurrent.CompletionStage;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.reactive.publisher.impl.PublisherHandler;
import org.infinispan.remoting.transport.NodeVersion;
import org.infinispan.util.ByteString;

@ProtoTypeId(value=1142)
public class NextPublisherCommand
extends BaseRpcCommand
implements TopologyAffectedCommand {
    @ProtoField(value=2)
    final String requestId;
    private int topologyId = -1;

    @ProtoFactory
    public NextPublisherCommand(ByteString cacheName, String requestId) {
        super(cacheName);
        this.requestId = requestId;
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry componentRegistry) throws Throwable {
        PublisherHandler publisherHandler = componentRegistry.getPublisherHandler().running();
        return publisherHandler.getNext(this.requestId);
    }

    @Override
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public NodeVersion supportedSince() {
        return NodeVersion.SIXTEEN;
    }
}

