/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.protostream.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.commons.marshall.MarshallingException;
import org.infinispan.marshall.protostream.impl.WrappedMessages;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoName;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.transaction.WriteSkewException;

@ProtoName(value="Throwable")
@ProtoTypeId(value=24)
public class MarshallableThrowable {
    private volatile Throwable throwable;
    private static final Set<Class<?>> MARSHALLABLE_EXCEPTIONS = new HashSet();
    @ProtoField(value=1)
    final WrappedMessage wrappedThrowable;
    @ProtoField(number=2, name="implementation")
    final String impl;
    @ProtoField(number=3, name="message")
    final String msg;
    @ProtoField(value=4)
    final MarshallableThrowable cause;
    @ProtoField(value=5)
    final ArrayList<MarshallableThrowable> suppressed;

    @ProtoFactory
    MarshallableThrowable(WrappedMessage wrappedThrowable, String impl, String msg, MarshallableThrowable cause, ArrayList<MarshallableThrowable> suppressed) {
        this.throwable = (Throwable)WrappedMessages.unwrap(wrappedThrowable);
        this.wrappedThrowable = wrappedThrowable;
        this.impl = impl;
        this.msg = msg;
        this.cause = cause;
        this.suppressed = suppressed;
    }

    public static MarshallableThrowable create(Throwable t) {
        if (t == null) {
            return null;
        }
        if (MARSHALLABLE_EXCEPTIONS.contains(t.getClass())) {
            return new MarshallableThrowable(new WrappedMessage((Object)t), null, null, null, null);
        }
        ArrayList suppressed = t.getSuppressed().length == 0 ? null : Stream.of(t.getSuppressed()).map(MarshallableThrowable::create).collect(Collectors.toCollection(ArrayList::new));
        return new MarshallableThrowable(null, t.getClass().getName(), t.getMessage(), MarshallableThrowable.create(t.getCause()), suppressed);
    }

    public static Throwable unwrap(MarshallableThrowable t) {
        return t == null ? null : t.get();
    }

    public Throwable get() {
        if (this.throwable == null) {
            this.throwable = this.recreateGenericThrowable(this.impl, this.msg, this.cause);
            if (this.suppressed != null) {
                this.suppressed.forEach(s -> this.throwable.addSuppressed(s.get()));
            }
        }
        return this.throwable;
    }

    private Throwable recreateGenericThrowable(String impl, String msg, MarshallableThrowable t) {
        Throwable cause = t == null ? null : t.get();
        try {
            Object retVal;
            Class<?> clazz = Class.forName(impl);
            if (cause == null && msg == null) {
                MarshallableThrowable marshallableThrowable = this;
                retVal = this.create(clazz, x$0 -> marshallableThrowable.getInstance((Constructor<?>)x$0, new Object[0]), new Class[0]);
            } else if (cause == null) {
                retVal = this.create(clazz, c -> this.getInstance((Constructor<?>)c, msg), String.class);
            } else if (msg == null) {
                retVal = this.create(clazz, c -> this.getInstance((Constructor<?>)c, cause), Throwable.class);
            } else {
                retVal = this.create(clazz, c -> this.getInstance((Constructor<?>)c, msg, cause), String.class, Throwable.class);
                if (retVal == null) {
                    retVal = this.create(clazz, c -> this.getInstance((Constructor<?>)c, cause), Throwable.class);
                }
            }
            return (Throwable)retVal;
        }
        catch (ClassNotFoundException e) {
            throw new MarshallingException((Throwable)e);
        }
    }

    private Object create(Class<?> clazz, Function<Constructor<?>, ?> builder, Class<?> ... args) {
        try {
            Constructor<?> ctor = clazz.getConstructor(args);
            return builder.apply(ctor);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private Object getInstance(Constructor<?> constructor, Object ... args) {
        try {
            return constructor.newInstance(args);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new MarshallingException((Throwable)e);
        }
    }

    public String toString() {
        return this.get().toString();
    }

    static {
        MARSHALLABLE_EXCEPTIONS.add(WriteSkewException.class);
    }
}

