/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.protostream.impl;

import java.lang.invoke.SerializedLambda;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.infinispan.commons.marshall.MarshallingException;
import org.infinispan.marshall.protostream.impl.MarshallableArray;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=20)
public class MarshallableLambda {
    @ProtoField(value=1)
    final String capturingClass;
    @ProtoField(value=2)
    final String functionalInterfaceClass;
    @ProtoField(value=3)
    final String functionalInterfaceMethodName;
    @ProtoField(value=4)
    final String functionalInterfaceMethodSignature;
    @ProtoField(value=5)
    int implMethodKind;
    @ProtoField(value=6)
    final String implClass;
    @ProtoField(value=7)
    final String implMethodName;
    @ProtoField(value=8)
    final String implMethodSignature;
    @ProtoField(value=9)
    final String instantiatedMethodType;
    @ProtoField(value=10)
    final MarshallableArray<Object> arguments;

    @ProtoFactory
    MarshallableLambda(String capturingClass, String functionalInterfaceClass, String functionalInterfaceMethodName, String functionalInterfaceMethodSignature, int implMethodKind, String implClass, String implMethodName, String implMethodSignature, String instantiatedMethodType, MarshallableArray<Object> arguments) {
        this.capturingClass = capturingClass;
        this.functionalInterfaceClass = functionalInterfaceClass;
        this.functionalInterfaceMethodName = functionalInterfaceMethodName;
        this.functionalInterfaceMethodSignature = functionalInterfaceMethodSignature;
        this.implMethodKind = implMethodKind;
        this.implClass = implClass;
        this.implMethodName = implMethodName;
        this.implMethodSignature = implMethodSignature;
        this.instantiatedMethodType = instantiatedMethodType;
        this.arguments = arguments;
    }

    public static MarshallableLambda create(Object o) {
        try {
            Method writeReplace = o.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            writeReplace.setAccessible(true);
            SerializedLambda sl = (SerializedLambda)writeReplace.invoke(o, new Object[0]);
            int numberOfArgs = sl.getCapturedArgCount();
            Object[] args = new Object[numberOfArgs];
            for (int i = 0; i < numberOfArgs; ++i) {
                args[i] = sl.getCapturedArg(i);
            }
            MarshallableArray<Object> wrappedArgs = MarshallableArray.create(args);
            return new MarshallableLambda(sl.getCapturingClass().replace("/", "."), sl.getFunctionalInterfaceClass(), sl.getFunctionalInterfaceMethodName(), sl.getFunctionalInterfaceMethodSignature(), sl.getImplMethodKind(), sl.getImplClass(), sl.getImplMethodName(), sl.getImplMethodSignature(), sl.getInstantiatedMethodType(), wrappedArgs);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new MarshallingException((Throwable)e);
        }
    }

    public Object unwrap(ClassLoader classLoader) {
        try {
            Class<?> clazz = Class.forName(this.capturingClass, true, classLoader);
            Object[] args = MarshallableArray.unwrap(this.arguments);
            SerializedLambda sl = new SerializedLambda(clazz, this.functionalInterfaceClass, this.functionalInterfaceMethodName, this.functionalInterfaceMethodSignature, this.implMethodKind, this.implClass, this.implMethodName, this.implMethodSignature, this.instantiatedMethodType, args);
            Method method = clazz.getDeclaredMethod("$deserializeLambda$", SerializedLambda.class);
            method.setAccessible(true);
            return method.invoke(null, sl);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new MarshallingException((Throwable)e);
        }
    }
}

