/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.protostream.impl;

import java.io.IOException;
import java.util.Collection;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.marshall.protostream.impl.AbstractInternalProtoStreamMarshaller;
import org.infinispan.marshall.protostream.impl.GlobalContextInitializer;
import org.infinispan.protostream.ProtobufTagMarshaller;
import org.infinispan.protostream.TagReader;
import org.infinispan.protostream.TagWriter;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.impl.GeneratedMarshallerBase;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

abstract class AbstractMarshallableCollection<T> {
    static final Log log = LogFactory.getLog(AbstractMarshallableCollection.class);

    AbstractMarshallableCollection() {
    }

    @ProtoField(value=1)
    int getSize() {
        throw log.marshallerNotOverridden(this.getClass().getName());
    }

    abstract Collection<T> get();

    static abstract class Marshaller
    extends GeneratedMarshallerBase
    implements ProtobufTagMarshaller<AbstractMarshallableCollection> {
        private final String typeName;
        private final AbstractInternalProtoStreamMarshaller marshaller;

        protected Marshaller(AbstractInternalProtoStreamMarshaller marshaller) {
            this.marshaller = marshaller;
            this.typeName = GlobalContextInitializer.getFqTypeName(this.getJavaClass());
        }

        abstract Collection<Object> newCollection(int var1);

        abstract AbstractMarshallableCollection<?> newWrapperInstance(Collection<?> var1);

        public AbstractMarshallableCollection read(ProtobufTagMarshaller.ReadContext ctx) throws IOException {
            TagReader in = ctx.getReader();
            int tag = in.readTag();
            if (tag == 0) {
                return this.newWrapperInstance(this.newCollection(0));
            }
            if (tag != 8) {
                throw new IllegalStateException("Unexpected tag: " + tag);
            }
            int size = in.readInt32();
            Collection<Object> entries = this.newCollection(size);
            boolean done = false;
            block4: while (!done) {
                tag = in.readTag();
                switch (tag) {
                    case 0: {
                        done = true;
                        continue block4;
                    }
                    case 18: {
                        byte[] bytes = in.readByteArray();
                        entries.add(this.marshaller.objectFromByteBuffer(bytes));
                        continue block4;
                    }
                }
                if (in.skipField(tag)) continue;
                done = true;
            }
            return this.newWrapperInstance(entries);
        }

        public void write(ProtobufTagMarshaller.WriteContext ctx, AbstractMarshallableCollection abstractMarshallableCollection) throws IOException {
            Collection collection = abstractMarshallableCollection.get();
            if (collection != null && !collection.isEmpty()) {
                TagWriter writer = ctx.getWriter();
                writer.writeInt32(1, collection.size());
                for (Object entry : collection) {
                    ByteBuffer buf = this.marshaller.objectToBuffer(entry);
                    writer.writeBytes(2, buf.getBuf(), buf.getOffset(), buf.getLength());
                }
            }
        }

        public String getTypeName() {
            return this.typeName;
        }
    }
}

