/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.filter;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.infinispan.CacheStream;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.NullCacheEntry;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.filter.Converter;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.filter.KeyValueFilterConverter;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.metadata.Metadata;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

public final class CacheFilters {
    private CacheFilters() {
    }

    public static <K, V> Predicate<CacheEntry<K, V>> predicate(KeyValueFilter<? super K, ? super V> filter) {
        return new KeyValueFilterAsPredicate<K, V>(filter);
    }

    public static <K, V, C> Function<CacheEntry<K, V>, CacheEntry<K, C>> function(Converter<? super K, ? super V, C> converter) {
        return new ConverterAsCacheEntryFunction<K, V, C>(converter);
    }

    public static <K, V, C> Function<CacheEntry<K, V>, CacheEntry<K, C>> converterToFunction(KeyValueFilterConverter<? super K, ? super V, C> filterConverter) {
        return new FilterConverterAsCacheEntryFunction<K, V, C>(filterConverter);
    }

    public static <K, V> Predicate<CacheEntry<K, V>> notNullCacheEntryPredicate() {
        return NotNullCacheEntryPredicate.SINGLETON;
    }

    public static <K, V, C> CacheStream<K> filterAndConvertToKey(CacheStream<CacheEntry<K, V>> stream, KeyValueFilterConverter<? super K, ? super V, C> filterConverter) {
        return stream.flatMap(new FilterConverterAsKeyFunction<K, V>(filterConverter));
    }

    public static <K, V, C> CacheStream<C> filterAndConvertToValue(CacheStream<CacheEntry<K, V>> stream, KeyValueFilterConverter<? super K, ? super V, C> filterConverter) {
        return stream.flatMap(new FilterConverterAsValueFunction<K, V, C>(filterConverter));
    }

    public static <K, V, C> Stream<CacheEntry<K, C>> filterAndConvert(Stream<CacheEntry<K, V>> stream, KeyValueFilterConverter<? super K, ? super V, C> filterConverter) {
        return stream.map(CacheFilters.converterToFunction(filterConverter)).filter(CacheFilters.notNullCacheEntryPredicate());
    }

    public static <K, V, C> CacheStream<CacheEntry<K, C>> filterAndConvert(CacheStream<CacheEntry<K, V>> stream, KeyValueFilterConverter<? super K, ? super V, C> filterConverter) {
        return stream.map(CacheFilters.converterToFunction(filterConverter)).filter(CacheFilters.notNullCacheEntryPredicate());
    }

    @ProtoTypeId(value=1036)
    @Scope(value=Scopes.NONE)
    public static final class KeyValueFilterAsPredicate<K, V>
    implements Predicate<CacheEntry<K, V>> {
        private final KeyValueFilter<? super K, ? super V> filter;

        public KeyValueFilterAsPredicate(KeyValueFilter<? super K, ? super V> filter) {
            Objects.requireNonNull(filter);
            this.filter = filter;
        }

        @ProtoFactory
        KeyValueFilterAsPredicate(MarshallableObject<KeyValueFilter<? super K, ? super V>> filter) {
            this.filter = MarshallableObject.unwrap(filter);
        }

        @ProtoField(value=1)
        MarshallableObject<KeyValueFilter<? super K, ? super V>> getFilter() {
            return MarshallableObject.create(this.filter);
        }

        @Override
        public boolean test(CacheEntry<K, V> kvCacheEntry) {
            return this.filter.accept(kvCacheEntry.getKey(), kvCacheEntry.getValue(), kvCacheEntry.getMetadata());
        }

        @Inject
        public void inject(ComponentRegistry registry) {
            registry.wireDependencies(this.filter);
        }
    }

    @ProtoTypeId(value=1032)
    @Scope(value=Scopes.NONE)
    public static final class ConverterAsCacheEntryFunction<K, V, C>
    implements Function<CacheEntry<K, V>, CacheEntry<K, C>> {
        private final Converter<? super K, ? super V, C> converter;
        private InternalEntryFactory factory;

        public ConverterAsCacheEntryFunction(Converter<? super K, ? super V, C> converter) {
            Objects.requireNonNull(converter);
            this.converter = converter;
        }

        @ProtoFactory
        ConverterAsCacheEntryFunction(MarshallableObject<Converter<? super K, ? super V, C>> converter) {
            this.converter = MarshallableObject.unwrap(converter);
        }

        @ProtoField(value=1)
        MarshallableObject<Converter<? super K, ? super V, C>> getConverter() {
            return MarshallableObject.create(this.converter);
        }

        @Inject
        public void inject(InternalEntryFactory factory, ComponentRegistry registry) {
            this.factory = factory;
            registry.wireDependencies(this.converter);
        }

        @Override
        public CacheEntry<K, C> apply(CacheEntry<K, V> kvCacheEntry) {
            Metadata metadata;
            C converted;
            K key = kvCacheEntry.getKey();
            V value = kvCacheEntry.getValue();
            if (value == (converted = this.converter.convert(key, value, metadata = kvCacheEntry.getMetadata()))) {
                return kvCacheEntry;
            }
            return this.factory.create(key, converted, metadata);
        }
    }

    @ProtoTypeId(value=1033)
    @Scope(value=Scopes.NONE)
    public static final class FilterConverterAsCacheEntryFunction<K, V, C>
    implements Function<CacheEntry<K, V>, CacheEntry<K, C>> {
        private final KeyValueFilterConverter<? super K, ? super V, C> filterConverter;
        private InternalEntryFactory factory;

        FilterConverterAsCacheEntryFunction(KeyValueFilterConverter<? super K, ? super V, C> filterConverter) {
            this.filterConverter = Objects.requireNonNull(filterConverter);
        }

        @ProtoFactory
        FilterConverterAsCacheEntryFunction(MarshallableObject<KeyValueFilterConverter<? super K, ? super V, C>> filterConverter) {
            this.filterConverter = MarshallableObject.unwrap(filterConverter);
        }

        @ProtoField(value=1)
        MarshallableObject<KeyValueFilterConverter<? super K, ? super V, C>> getFilterConverter() {
            return MarshallableObject.create(this.filterConverter);
        }

        @Inject
        public void inject(InternalEntryFactory factory, ComponentRegistry registry) {
            this.factory = factory;
            registry.wireDependencies(this.filterConverter);
        }

        @Override
        public CacheEntry<K, C> apply(CacheEntry<K, V> kvCacheEntry) {
            Metadata metadata;
            V value;
            K key = kvCacheEntry.getKey();
            C converted = this.filterConverter.filterAndConvert(key, value = kvCacheEntry.getValue(), metadata = kvCacheEntry.getMetadata());
            if (converted == null) {
                return NullCacheEntry.getInstance();
            }
            if (value == converted) {
                return kvCacheEntry;
            }
            return this.factory.create(key, converted, metadata);
        }
    }

    @ProtoTypeId(value=1037)
    @Scope(value=Scopes.NONE)
    public static class NotNullCacheEntryPredicate<K, V>
    implements Predicate<CacheEntry<K, V>> {
        private static final NotNullCacheEntryPredicate SINGLETON = new NotNullCacheEntryPredicate();

        @Override
        public boolean test(CacheEntry<K, V> kvCacheEntry) {
            return kvCacheEntry != null && kvCacheEntry != NullCacheEntry.getInstance();
        }
    }

    @ProtoTypeId(value=1034)
    @Scope(value=Scopes.NONE)
    public static final class FilterConverterAsKeyFunction<K, V>
    implements Function<CacheEntry<K, V>, Stream<K>> {
        private final KeyValueFilterConverter<? super K, ? super V, ?> converter;

        public FilterConverterAsKeyFunction(KeyValueFilterConverter<? super K, ? super V, ? super K> converter) {
            Objects.requireNonNull(converter);
            this.converter = converter;
        }

        @ProtoFactory
        FilterConverterAsKeyFunction(MarshallableObject<KeyValueFilterConverter<? super K, ? super V, ? super K>> converter) {
            this.converter = MarshallableObject.unwrap(converter);
        }

        @ProtoField(value=1)
        MarshallableObject<KeyValueFilterConverter<? super K, ? super V, ?>> getConverter() {
            return MarshallableObject.create(this.converter);
        }

        @Inject
        public void inject(ComponentRegistry registry) {
            registry.wireDependencies(this.converter);
        }

        @Override
        public Stream<K> apply(CacheEntry<K, V> entry) {
            Object converted = this.converter.filterAndConvert(entry.getKey(), entry.getValue(), entry.getMetadata());
            if (converted == null) {
                return Stream.empty();
            }
            return Stream.of(entry.getKey());
        }
    }

    @ProtoTypeId(value=1035)
    @Scope(value=Scopes.NONE)
    public static final class FilterConverterAsValueFunction<K, V, C>
    implements Function<CacheEntry<K, V>, Stream<C>> {
        private final KeyValueFilterConverter<? super K, ? super V, C> converter;

        public FilterConverterAsValueFunction(KeyValueFilterConverter<? super K, ? super V, C> converter) {
            Objects.requireNonNull(converter);
            this.converter = converter;
        }

        @ProtoFactory
        FilterConverterAsValueFunction(MarshallableObject<KeyValueFilterConverter<? super K, ? super V, C>> converter) {
            this.converter = MarshallableObject.unwrap(converter);
        }

        @ProtoField(value=1)
        MarshallableObject<KeyValueFilterConverter<? super K, ? super V, C>> getConverter() {
            return MarshallableObject.create(this.converter);
        }

        @Inject
        public void inject(ComponentRegistry registry) {
            registry.wireDependencies(this.converter);
        }

        @Override
        public Stream<C> apply(CacheEntry<K, V> entry) {
            C converted = this.converter.filterAndConvert(entry.getKey(), entry.getValue(), entry.getMetadata());
            if (converted == null) {
                return Stream.empty();
            }
            return Stream.of(converted);
        }
    }
}

