/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.impl.PersistedMembers;
import org.infinispan.globalstate.ScopedPersistentState;
import org.infinispan.remoting.transport.Address;

public abstract class AbstractConsistentHash
implements ConsistentHash {
    protected static final String STATE_CAPACITY_FACTOR = "capacityFactor.%d";
    protected static final String STATE_CAPACITY_FACTORS = "capacityFactors";
    protected static final String STATE_NUM_SEGMENTS = "numSegments";
    protected final List<Address> members;
    protected final List<Float> capacityFactors;

    protected AbstractConsistentHash(int numSegments, List<Address> members, Map<Address, Float> capacityFactors) {
        if (numSegments < 1) {
            throw new IllegalArgumentException("The number of segments must be strictly positive");
        }
        this.members = new ArrayList<Address>(members);
        if (capacityFactors == null) {
            this.capacityFactors = null;
        } else {
            this.capacityFactors = new ArrayList<Float>(members.size());
            for (Address member : members) {
                this.capacityFactors.add(capacityFactors.get(member));
            }
        }
    }

    protected AbstractConsistentHash(int numSegments, List<Address> members, List<Float> capacityFactors) {
        if (numSegments < 1) {
            throw new IllegalArgumentException("The number of segments must be strictly positive");
        }
        this.members = members;
        this.capacityFactors = capacityFactors;
    }

    protected static int parseNumSegments(ScopedPersistentState state) {
        return state.getIntProperty(STATE_NUM_SEGMENTS);
    }

    protected static PersistedMembers parseMembers(ScopedPersistentState state, Function<UUID, Address> addressMapper) {
        int numMembers = Integer.parseInt(state.getProperty("members"));
        int numCapacityFactors = Integer.parseInt(state.getProperty(STATE_CAPACITY_FACTORS));
        assert (numCapacityFactors == 0 || numCapacityFactors == numMembers);
        ArrayList<Address> members = new ArrayList<Address>(numMembers);
        HashMap<Address, Float> capacityFactors = new HashMap<Address, Float>();
        ArrayList<UUID> missingUuids = new ArrayList<UUID>(numMembers);
        for (int i = 0; i < numMembers; ++i) {
            UUID uuid = UUID.fromString(state.getProperty(String.format("member.%d", i)));
            Address address = addressMapper.apply(uuid);
            if (address == null) {
                missingUuids.add(uuid);
                continue;
            }
            members.add(address);
            String factor = state.getProperty(String.format(STATE_CAPACITY_FACTOR, i));
            if (factor == null) continue;
            capacityFactors.put(address, Float.valueOf(Float.parseFloat(factor)));
        }
        return new PersistedMembers(members, capacityFactors, missingUuids);
    }

    @Override
    public void toScopedState(ScopedPersistentState state, Function<Address, UUID> addressMapper) {
        state.setProperty("consistentHash", this.getClass().getName());
        state.setProperty(STATE_NUM_SEGMENTS, this.getNumSegments());
        AbstractConsistentHash.writeAddressToState(state, this.members, "members", "member.%d", addressMapper);
        state.setProperty(STATE_CAPACITY_FACTORS, this.capacityFactors.size());
        for (int i = 0; i < this.capacityFactors.size(); ++i) {
            state.setProperty(String.format(STATE_CAPACITY_FACTOR, i), this.capacityFactors.get(i).floatValue());
        }
    }

    @Override
    public List<Address> getMembers() {
        return this.members;
    }

    protected static void mergeLists(List<Address> dest, List<Address> src) {
        for (Address node : src) {
            if (dest.contains(node)) continue;
            dest.add(node);
        }
    }

    public static HashMap<Address, Integer> getMemberIndexMap(List<Address> members) {
        HashMap<Address, Integer> memberIndexes = new HashMap<Address, Integer>(members.size());
        for (int i = 0; i < members.size(); ++i) {
            memberIndexes.put(members.get(i), i);
        }
        return memberIndexes;
    }

    @Override
    public Map<Address, Float> getCapacityFactors() {
        if (this.capacityFactors == null) {
            return null;
        }
        HashMap<Address, Float> capacityFactorsMap = new HashMap<Address, Float>(this.members.size());
        for (int i = 0; i < this.members.size(); ++i) {
            capacityFactorsMap.put(this.members.get(i), this.capacityFactors.get(i));
        }
        return capacityFactorsMap;
    }

    protected Map<Address, Float> unionCapacityFactors(AbstractConsistentHash ch2) {
        HashMap<Address, Float> unionCapacityFactors = null;
        if (this.capacityFactors != null || ch2.capacityFactors != null) {
            unionCapacityFactors = new HashMap<Address, Float>();
            if (this.capacityFactors != null) {
                unionCapacityFactors.putAll(this.getCapacityFactors());
            } else {
                for (Address node : this.members) {
                    unionCapacityFactors.put(node, Float.valueOf(1.0f));
                }
            }
            if (ch2.capacityFactors != null) {
                unionCapacityFactors.putAll(ch2.getCapacityFactors());
            } else {
                for (Address node : ch2.members) {
                    unionCapacityFactors.put(node, Float.valueOf(1.0f));
                }
            }
        }
        return unionCapacityFactors;
    }

    protected void checkSameHashAndSegments(AbstractConsistentHash dch2) {
        int numSegments = this.getNumSegments();
        if (numSegments != dch2.getNumSegments()) {
            throw new IllegalArgumentException("The consistent hash objects must have the same number of segments");
        }
    }

    protected static void writeAddressToState(ScopedPersistentState state, List<Address> members, String sizeKey, String memberKeyFormat, Function<Address, UUID> addressMapper) {
        state.setProperty(sizeKey, members.size());
        for (int i = 0; i < members.size(); ++i) {
            state.setProperty(String.format(memberKeyFormat, i), addressMapper.apply(members.get(i)).toString());
        }
    }
}

